/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*    ITRONJ[l Œ蒷v[                                      */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_mpf.h"



/* Œ蒷ubN̕ԋp */
ER rel_mpf(
		ID mpfid,		/* ubNlΏۂ̌Œ蒷v[IDԍ */
		VP blk)			/* ԋp郁ubN̐擪Ԓn */
{
	T_KERNEL_MPFCB_RAM *mpfcb_ram;
	T_MKNL_TCB *mtcb;

	/* ID ̃`FbN */
#ifdef HOS_ERCHK_E_ID
	if ( mpfid < KERNEL_TMIN_MPFID || mpfid > KERNEL_TMAX_MPFID )
	{
		return E_ID;	/* IDs */
	}
#endif

	mknl_loc_sys();	/* VXẽbN */

	mpfcb_ram = KERNEL_MPFID_TO_MPFCB_RAM(mpfid);

	/* IuWFNg݃`FbN */
#ifdef HOS_ERCHK_E_NOEXS
	if ( mpfcb_ram == NULL )
	{
		mknl_unl_sys();	/* VXẽbN */
		return E_NOEXS;	/* IuWFNg */
	}
#endif

	mtcb = mknl_ref_qhd(&mpfcb_ram->que);	/* ҂s擪^XNo */
	if ( mtcb != NULL )
	{
		/* ҂^XNΑ҂ */
		mknl_rmv_que(mtcb);						/* v[̑҂s񂩂폜 */
		mknl_rmv_tmout(mtcb);					/* ^CAEg҂s񂩂폜 */
		mtcb->data = (VP_INT)blk;				/* ubN̐擪Ԓnݒ */
		mknl_wup_tsk(mtcb, E_OK);				/* ^XN̑҂ */
		
		mknl_exe_dsp();		/* ^XNfBXpb`̎s */
		mknl_exe_tex();		/* O̎s */
	}
	else
	{
		/* ҂^XN΃v[ɕԋp */
		*(VP *)blk      = mpfcb_ram->free;
		mpfcb_ram->free = blk;
	}

	mknl_unl_sys();		/* VXẽbN */

	return E_OK;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
