/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*    ITRONJ[l Œ蒷v[                                      */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_mpf.h"



/* Œ蒷ubN̊l(^CAEg) */
ER tget_mpf(
		ID  mpfid,		/* ubNlΏۂ̌Œ蒷v[IDԍ */
		VP  *p_blk,		/* lubN̐擪Ԓn */
		TMO tmout)		/* ^CAEgw */
{
	const T_KERNEL_MPFCB_ROM *mpfcb_rom;
	T_KERNEL_MPFCB_RAM       *mpfcb_ram;
	T_MKNL_TCB *mtcb;
	ER ercd;

	/* ID ̃`FbN */
#ifdef HOS_ERCHK_E_ID
	if ( mpfid < KERNEL_TMIN_MPFID || mpfid > KERNEL_TMAX_MPFID )
	{
		return E_ID;	/* IDs */
	}
#endif

	/* p[^[`FbN */
#ifdef HOS_ERCHK_E_PAR 
	if ( tmout != TMO_FEVR && tmout < 0 )
	{
		return E_PAR;
	}
#endif

	mknl_loc_sys();	/* VXẽbN */

	/* ReLXg`FbN */
#ifdef HOS_ERCHK_E_CTX
	if ( tmout != TMO_POL &&  mknl_sns_wai() )
	{
		mknl_unl_sys();	/* VXẽbN */
		return E_CTX;	/* ReLXgs */
	}
#endif

	mpfcb_ram = KERNEL_MPFID_TO_MPFCB_RAM(mpfid);

	/* IuWFNg݃`FbN */
#ifdef HOS_ERCHK_E_NOEXS
	if ( mpfcb_ram == NULL )
	{
		mknl_unl_sys();	/* VXẽbN */
		return E_NOEXS;	/* IuWFNg */
	}
#endif

	if ( mpfcb_ram->free != NULL )
	{
		/* 󂫃ubNΊ蓖Ă */
		*p_blk          = mpfcb_ram->free;
		mpfcb_ram->free = *(VP *)mpfcb_ram->free;	/* ̋󂫃GAݒ */
		ercd = E_OK;
	}
	else
	{
		if ( tmout == TMO_POL )
		{
			/* |[OȂ瑦^CAEg */
			ercd = E_TMOUT;
		}
		else
		{
			/* 󂫃ubNΑ҂ɓ */
			mpfcb_rom = mpfcb_ram->mpfcb_rom;
			mtcb = mknl_get_run_tsk();
			mknl_wai_tsk(mtcb, TTW_MPF);
			mknl_add_que(&mpfcb_ram->que, mtcb, mpfcb_rom->mpfatr);	/* ҂sɒǉ */
			
			/* ҂łȂ΃^CAEgݒ */
			if ( tmout != TMO_FEVR )
			{
				mknl_add_tmout(mtcb, (RELTIM)tmout);	/* ^CAEgL[ɒǉ */
			}
			
			ercd = (ER)mknl_exe_dsp();	/* ^XNfBXpb`̎s */
			
			if ( ercd == E_OK )
			{
				*p_blk = (VP)mtcb->data;	/* lubN擪Ԓni[ */
			}
			
			mknl_exe_tex();		/* O̎s */
		}
	}
	
	mknl_unl_sys();		/* VXẽbN */
	
	return ercd;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
