/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*    ITRONJ[l Z}tH                                                */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_sem.h"



/* Z}tH̐ */
ER cre_sem(
		ID           semid,		/* Ώۂ̃Z}tHIDԍ */
		const T_CSEM *pk_csem)	/* Z}tHꂽpPbgւ̃|C^ */
{
	ER ercd;

	/* ID ̃`FbN */
#ifdef HOS_ERCHK_E_ID
	if ( semid < KERNEL_TMIN_SEMID || semid > KERNEL_TMAX_SEMID )
	{
		return E_ID;	/* sID */
	}
#endif

	mknl_loc_sys();	/* VXẽbN */

	/* Z}tHo^\ǂ`FbN */
#ifdef HOS_ERCHK_E_OBJ
	if ( KERNEL_SEMID_TO_SEMCB_RAM(semid) != NULL )
	{
		mknl_unl_sys();	/* VXẽbN */
		return E_OBJ;	/* ɓo^ς */
	}
#endif

	/* Z}tH̐ */
	ercd = kernel_cre_sem(semid, pk_csem);
	
	mknl_unl_sys();	/* VXẽbN */

	return ercd;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
