/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*    ITRONJ[l Z}tH                                                */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_sem.h"
#include "knl_mem.h"


/* Z}tH̍폜 */
ER del_sem(
		ID semid)	/* 폜Ώۂ̃Z}tHIDԍ */
{
	T_KERNEL_SEMCB_RAM *semcb_ram;

	/* ID ̃`FbN */
#ifdef HOS_ERCHK_E_ID
	if ( semid < KERNEL_TMIN_SEMID || semid > KERNEL_TMAX_SEMID )
	{
		return E_ID;	/* sID */
	}
#endif

	mknl_loc_sys();	/* VXẽbN */

	semcb_ram = KERNEL_SEMID_TO_SEMCB_RAM(semid);

	/* IuWFNg݃`FbN */
#ifdef HOS_ERCHK_E_NOEXS
	if ( semcb_ram == NULL )
	{
		mknl_unl_sys();	/* VXẽbN */
		return E_NOEXS;	/* IuWFNg */
	}
#endif
	
	/* ҂^XN̉ */
	mknl_clr_que(&semcb_ram->que);
	
	/* ̉ */
	kernel_fre_mem(semcb_ram);
	KERNEL_SEMID_TO_SEMCB_RAM(semid) = NULL;
	
	mknl_exe_dsp();		/* ^XNfBXpb`̎s */
	mknl_exe_tex();		/* O̎s */
	
	mknl_unl_sys();	/* VXẽbN */

	return E_OK;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
