/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*    ITRONJ[l Z}tH                                                */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_sem.h"
#include "knl_mem.h"


/* Z}tHRg[ubN(Ip) */
typedef struct t_kernel_semcb
{
	T_KERNEL_SEMCB_RAM semcb_ram;	/* Z}tHRg[ubN(RAM) */
	T_KERNEL_SEMCB_ROM semcb_rom;	/* Z}tHRg[ubN(ROM) */
} T_KERNEL_SEMCB;



/* Z}tH̐(J[l֐) */
ER kernel_cre_sem(
		ID           semid,		/* Ώۂ̃Z}tHIDԍ */
		const T_CSEM *pk_csem)	/* Z}tHꂽpPbgւ̃|C^ */
{
	T_KERNEL_SEMCB     *semcb;
	T_KERNEL_SEMCB_RAM *semcb_ram;
	T_KERNEL_SEMCB_ROM *semcb_rom;

	/* p[^[`FbN */
#ifdef HOS_ERCHK_E_RSATR
	if ( pk_csem->sematr & ~(TA_TFIFO | TA_TPRI) )
	{
		return E_RSATR;
	}
#endif

	/* Z}tHp̊m */
	semcb = (T_KERNEL_SEMCB *)kernel_alc_mem(sizeof(T_KERNEL_SEMCB));
#ifdef HOS_ERCHK_E_NOMEM
	if ( semcb == NULL )
	{
		return E_NOMEM;		/* s */
	}
#endif

	/* Z}tH̐ݒ */
	semcb_ram = &semcb->semcb_ram;
	semcb_rom = &semcb->semcb_rom;
	mknl_ini_que(&semcb_ram->que);
	semcb_ram->semcnt    = pk_csem->isemcnt;
	semcb_ram->semcb_rom = semcb_rom;
	semcb_rom->sematr    = pk_csem->sematr;
	semcb_rom->isemcnt   = pk_csem->isemcnt;
	semcb_rom->maxsem    = pk_csem->maxsem;

	/* Ǘe[u֒ǉ */
	KERNEL_SEMID_TO_SEMCB_RAM(semid) = semcb_ram;

	return E_OK;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
