/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*    ITRONJ[l Z}tH                                                */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_sem.h"



/* Z}tH̊l(|[O) */
ER pol_sem(
		ID semid)	/* lΏۂ̃Z}tHIDԍ */
{
	T_KERNEL_SEMCB_RAM *semcb_ram;
	ER ercd;

	/* ID ̃`FbN */
#ifdef HOS_ERCHK_E_ID
	if ( semid < KERNEL_TMIN_SEMID || semid > KERNEL_TMAX_SEMID )
	{
		return E_ID;
	}
#endif
	
	mknl_loc_sys();		/* VXẽbN */

	semcb_ram = KERNEL_SEMID_TO_SEMCB_RAM(semid);

	/* IuWFNg݃`FbN */
#ifdef HOS_ERCHK_E_NOEXS
	if ( semcb_ram == NULL )
	{
		mknl_unl_sys();		/* VXẽbN */
		return E_NOEXS;
	}
#endif

	/* Z}tHlłꖳ΃^CAEg */
	if ( semcb_ram->semcnt == 0 )
	{
		ercd = E_TMOUT;		/* ^CAEg */
	}
	else
	{
		semcb_ram->semcnt--;	/* Z}tH̊l */
		ercd = E_OK;
	}

	mknl_unl_sys();		/* VXẽbN */

	return ercd;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
