/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*    ITRONJ[l Z}tH                                                */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_sem.h"
#include "knl_sys.h"



/* Z}tH̏ԎQ */
ER ref_sem(
		ID     semid,		/* ԎQƑΏۂ̃Z}tHIDԍ */
		T_RSEM *pk_rsem)	/* Z}tHԂԂpPbgւ̃|C^ */
{
	T_KERNEL_SEMCB_RAM *semcb_ram;
	T_MKNL_TCB *mtcb;

	/* ID ̃`FbN */
#ifdef HOS_ERCHK_E_ID
	if ( semid < KERNEL_TMIN_SEMID || semid > KERNEL_TMAX_SEMID )
	{
		return E_ID;
	}
#endif

	/* p[^̃`FbN */
#ifdef HOS_ERCHK_E_PAR
	if ( pk_rsem == NULL )
	{
		return E_PAR;	/* p[^G[ */
	}
#endif

	mknl_loc_sys();	/* VXẽbN */

	semcb_ram = KERNEL_SEMID_TO_SEMCB_RAM(semid);

	/* IuWFNg݃`FbN */
#ifdef HOS_ERCHK_E_NOEXS
	if ( semcb_ram == NULL )
	{
		mknl_unl_sys();	/* VXẽbN */
		return E_NOEXS;	/* IuWFNg */
	}
#endif

	/* Z}tH̑҂s̐擪̃^XNIDԍ擾 */
	mtcb = mknl_ref_qhd(&semcb_ram->que);	/* ҂s擪^XNo */
	if ( mtcb == NULL )
	{
		pk_rsem->wtskid = TSK_NONE;		/* ҂^XNȂ */
	}
	else
	{
		/* ^XNID */
		pk_rsem->wtskid = kernel_get_tid(KERNEL_STATIC_CAST(T_KERNEL_TCB_RAM, mtcb, mtcb));
	}
	
	/* Z}tȞ݂̎擾 */
	pk_rsem->semcnt = semcb_ram->semcnt;

	mknl_unl_sys();	/* VXẽbN */

	return E_OK;	/*  */
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
