/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*    ITRONJ[l Z}tH                                                */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_sem.h"



/* Z}tH̕ԋp */
ER sig_sem(
		ID semid)		/* Z}tHԋpΏۂ̃Z}tHIDԍ */
{
	const T_KERNEL_SEMCB_ROM *semcb_rom;
	T_KERNEL_SEMCB_RAM *semcb_ram;
	T_MKNL_TCB *mtcb;
	
	/* ID ̃`FbN */
#ifdef HOS_ERCHK_E_ID
	if ( semid < KERNEL_TMIN_SEMID || semid > KERNEL_TMAX_SEMID )
	{
		return E_ID;
	}
#endif
	
	mknl_loc_sys();	/* VXẽbN */
	
	semcb_ram = KERNEL_SEMID_TO_SEMCB_RAM(semid);
	
	/* IuWFNg݃`FbN */
#ifdef HOS_ERCHK_E_NOEXS
	if ( semcb_ram == NULL )
	{
		mknl_unl_sys();	/* VXẽbN */
		return E_NOEXS;	/* IuWFNg */
	}
#endif
	
	semcb_rom = semcb_ram->semcb_rom;
	
	/* L[COI[o[t[`FbN */
#ifdef HOS_ERCHK_E_QOVR
	if ( semcb_ram->semcnt >= semcb_rom->maxsem )
	{
		mknl_unl_sys();	/* VXẽbN */
		return E_QOVR;
	}
#endif
	
	mtcb = mknl_ref_qhd(&semcb_ram->que);	/* ҂s擪^XNo */
	if ( mtcb != NULL )
	{
		/* ҂^XNΑ҂ */
		mknl_rmv_que(mtcb);						/* Z}tH̑҂s񂩂폜 */
		mknl_rmv_tmout(mtcb);					/* ^CAEg҂s񂩂폜 */
		mknl_wup_tsk(mtcb, E_OK);				/* ^XN̑҂ */
		
		mknl_exe_dsp();		/* ^XNfBXpb`̎s */
		mknl_exe_tex();		/* O̎s */
	}
	else
	{
		semcb_ram->semcnt++;	/* Z}tHԋp */
	}

	mknl_unl_sys();	/* VXẽbN */

	return E_OK;	/*  */
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
