/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*    ITRONJ[l Z}tH                                                */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_sem.h"



/* Z}tH̊l */
ER wai_sem(
		ID semid)	/* lΏۂ̃Z}tHIDԍ */
{
	const T_KERNEL_SEMCB_ROM *semcb_rom;
	T_KERNEL_SEMCB_RAM       *semcb_ram;
	T_MKNL_TCB *mtcb;
	ER ercd;

	/* ID ̃`FbN */
#ifdef HOS_ERCHK_E_ID
	if ( semid < KERNEL_TMIN_SEMID || semid > KERNEL_TMAX_SEMID )
	{
		return E_ID;	/* IDs */
	}
#endif

	mknl_loc_sys();	/* VXẽbN */

	/* ReLXg`FbN */
#ifdef HOS_ERCHK_E_CTX
	if ( mknl_sns_wai() )
	{
		mknl_unl_sys();	/* VXẽbN */
		return E_CTX;	/* ReLXgs */
	}
#endif

	semcb_ram = KERNEL_SEMID_TO_SEMCB_RAM(semid);

	/* IuWFNg݃`FbN */
#ifdef HOS_ERCHK_E_NOEXS
	if ( semcb_ram == NULL )
	{
		mknl_unl_sys();	/* VXẽbN */
		return E_NOEXS;	/* IuWFNg */
	}
#endif

	/* Z}tHlłΐ */
	if ( semcb_ram->semcnt > 0 )
	{
		semcb_ram->semcnt--;	/* Z}tH̊l */
		ercd = E_OK;
	}
	else
	{
		semcb_rom = semcb_ram->semcb_rom;

		/* ^XN҂Ԃɂ */
		mtcb = mknl_get_run_tsk();
		mknl_wai_tsk(mtcb, TTW_SEM);
		mknl_add_que(&semcb_ram->que, mtcb, semcb_rom->sematr);	/* ҂sɒǉ */
	
		ercd = (ER)mknl_exe_dsp();	/* ^XNfBXpb`̎s */
		mknl_exe_tex();				/* O̎s */
	}
		
	mknl_unl_sys();		/* VXẽbN */

	return ercd;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
