/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*    ITRONJ[l VXeԊǗ                                        */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_sys.h"



/* ^XND揇ʂ̉] */
ER rot_rdq(
		PRI tskpri)		/* D揇ʂ]Ώۂ̗Dx */
{
	T_MKNL_TCB* mtcb;

	/* ^XNDxw̏ */
	if ( tskpri == TPRI_SELF )
	{
#ifdef HOS_ERCHK_E_PAR
		if ( sns_ctx() )
		{
			return E_PAR;
		}
		mtcb   = mknl_get_run_tsk();	/* s^XN̎擾 */
		tskpri = mknl_get_pri(mtcb);	/* Dx̎擾 */
#endif
	}

	/* p[^[͈̓`FbN */
#ifdef HOS_ERCHK_E_PAR
	if ( tskpri < TMIN_TPRI ||  tskpri > TMAX_TPRI )
	{
		return E_PAR;
	}
#endif

	mknl_loc_sys();			/* VXẽbN */

	mknl_rot_rdq(tskpri);	/* ^XND揇ʂ̉] */
	
	mknl_exe_dsp();			/* ^XNfBXpb`̎s */
	mknl_exe_tex();			/* O̎s */
	
	mknl_unl_sys();			/* VXẽbN */
	
	return E_OK;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
