/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*    ITRONJ[l VXeԊǗ                                        */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_tim.h"



/* ^C}XgǗ */
T_KERNEL_TIM *kernel_tml_head;		/* ^C}Xg擪ʒu */
T_KERNEL_TIM *kernel_tml_ptr;		/* ^C}Xg|C^ */



/* ^CeBbN̋ */
ER isig_tim(void)
{
	T_KERNEL_TIM* tim_ptr;
	UW            prev_tim;
	RELTIM        tic;

	/* Z^CeBbNZo */
	/* Ⴆ 10/3 ms Ȃ 3, 3, 4, 3, 3, 4, ... ƃJEgĂ */
	kernel_tic_cnt--;
	if ( kernel_tic_cnt < kernel_tic_mod )
	{
		tic = kernel_tic_div + 1;	/* ؂Ȃ␳ */
	}
	else
	{
		tic = kernel_tic_div;
	}
	if ( kernel_tic_cnt == 0 )
	{
		kernel_tic_cnt = kernel_tic_deno;
	}

	mknl_loc_sys();		/* VXẽbN */

	/* VXe^CɉZ */
	prev_tim = kernel_systim.ltime;
	kernel_systim.ltime += tic;
	if ( kernel_systim.ltime < prev_tim )	/* オ肪Ȃ */
	{
		kernel_systim.utime++;
	}
	
	/* ^C}IuWFNg̃nhĂяo */
	if ( kernel_tml_head != NULL )
	{
		/* |C^ݒ */
		kernel_tml_ptr = kernel_tml_head;
		
		do /* Xg܂ŌJԂ */
		{
			/* ̃|C^Oɐݒ */
			tim_ptr        = kernel_tml_ptr;
			kernel_tml_ptr = tim_ptr->next;
			
			/* ^C}nhĂяo */
			tim_ptr->timhdr(tim_ptr, tic);
			
			/* nhō폜ꂽꍇ */
			if ( kernel_tml_ptr == NULL )
			{
				break;
			}
		} while ( kernel_tml_ptr != kernel_tml_head );
		
		/* |C^̃NA */
		kernel_tml_ptr = NULL;
	}
	
	/* ^CAEg҂s̃^XNN */
	mknl_tic_tmout(tic);	/* ^CAEgL[Ƀ^CeBbN */
	
	mknl_unl_sys();			/* VXẽbN */
	
	return E_OK;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
