/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*    ITRONJ[l ^XNǗ@\                                          */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_tsk.h"


/* ^XN̐(IDԍt) */
ER_ID acre_tsk(
		const T_CTSK *pk_ctsk)	/* ^XNꂽpPbgւ̃|C^ */
{
	ID tskid;
	ER ercd;

	mknl_loc_sys();	/* VXẽbN */

	/* IĎ */
	for ( tskid = KERNEL_TMAX_TSKID; tskid >= KERNEL_TMIN_TSKID; tskid-- )
	{
		if ( KERNEL_TSKID_TO_TCB_RAM(tskid) == NULL )
		{
			break;
		}
	}
	if ( tskid < KERNEL_TMIN_TSKID )
	{
		mknl_unl_sys();		/* VXẽbN */
		return E_NOID;		/* IDԍs */
	}
	
	/* ^XN̐ */
	ercd = kernel_cre_tsk(tskid, pk_ctsk);

	mknl_unl_sys();	/* VXẽbN */

	if ( ercd != E_OK )
	{
		return (ER_ID)ercd;	/* G[ */
	}

	return (ER_ID)tskid;		/*  */
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
