/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*    ITRONJ[l ^XNǗ@\                                          */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_tsk.h"



/* ^XN̋N */
ER act_tsk(
		ID tskid)	/* ^XNID */
{
	const T_KERNEL_TCB_ROM *tcb_rom;
	T_KERNEL_TCB_RAM       *tcb_ram;

	/* ID ͈̓`FbN */
#ifdef HOS_ERCHK_E_ID
	if ( tskid != TSK_SELF && (tskid < KERNEL_TMIN_TSKID || tskid > KERNEL_TMAX_TSKID) )
	{
		return E_ID;	/* sIDԍ */
	}
#endif

	mknl_loc_sys();	/* VXẽbN */

	/* ^XNRg[ubN擾 */
	if ( tskid == TSK_SELF )
	{
		/* ^XNw莞̕ϊ */
#ifdef HOS_ERCHK_E_ID
		if ( mknl_sns_ctx() )
		{
			/* ^XNReLXg TSK_SELFw͕s */
			mknl_unl_sys();		/* VXẽbN */
			return E_ID;		/* sIDԍ */
		}
#endif
		tcb_ram = kernel_get_run_tsk();
	}
	else
	{
		/* IDԍw莞̕ϊ */
		tcb_ram = KERNEL_TSKID_TO_TCB_RAM(tskid);

		/* IuWFNg݃`FbN */
#ifdef HOS_ERCHK_E_NOEXS
		if ( tcb_ram == NULL )
		{
			mknl_unl_sys();		/* VXẽbN */
			return E_NOEXS;		/* IuWFNg */
		}
#endif
	}

	/* IuWFNgԔ */
	if ( mknl_get_tskstat(&tcb_ram->mtcb) != TTS_DMT )
	{
		/* ɎsԂȂNvL[CO */
#ifdef HOS_ERCHK_E_QOVR
		if ( tcb_ram->actcnt >= TMAX_ACTCNT )
		{
			mknl_unl_sys();	/* VXẽbN */
			return E_QOVR;	/* L[COI[o[t[ */
		}
#endif

		/* NvL[CO */
		tcb_ram->actcnt++;
	}
	else
	{
		/* x~ԂȂ^XNN */
		tcb_rom = tcb_ram->tcb_rom;
	
		/* sReLXgo^ */
		mknl_sta_tsk(
				&tcb_ram->mtcb,			/* o^^XN */
				tcb_rom->exinf,			/* ^XN̊g */
				(FP)kernel_task_entry,	/* ^XN̋NԒn */
				tcb_rom->itskpri,		/* ^XN̋NDx */
				tcb_rom->stksz,			/* ^XÑX^bN̈TCY */
				tcb_rom->stk			/* ^XÑX^bN̈̐擪Ԓn */
			);	
		tcb_ram->suscnt = 0;	/* ҂lXgNA */
		tcb_ram->wupcnt = 0;	/* ҂vL[CONA */
		
		mknl_exe_dsp();			/* ^XNfBXpb`̎s */
		mknl_exe_tex();			/* O̎s */
	}

	mknl_unl_sys();	/* VXẽbN */

	return E_OK;	/*  */
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
