/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*    ITRONJ[l ^XNǗ@\                                          */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_tsk.h"


/* ^XN̐ */
ER cre_tsk(
		ID           tskid,		/* Ώۂ̃^XNIDԍ */
		const T_CTSK *pk_ctsk)	/* ^XNꂽpPbgւ̃|C^ */
{
	ER ercd;

	/* ID ͈̓`FbN */
#ifdef HOS_ERCHK_E_ID
	if ( tskid < KERNEL_TMIN_TSKID || tskid > KERNEL_TMAX_TSKID )
	{
		return E_ID;	/* sIDԍ */
	}
#endif

	mknl_loc_sys();	/* VXẽbN */

	/* ^XNo^\`FbN */
#ifdef HOS_ERCHK_E_OBJ
	if ( KERNEL_TSKID_TO_TCB_RAM(tskid) != NULL )
	{
		mknl_unl_sys();	/* VXẽbN */
		return E_OBJ;	/* ɓo^ς */
	}
#endif
	
	/* ^XN̐ */
	ercd = kernel_cre_tsk(tskid, pk_ctsk);

	mknl_unl_sys();	/* VXẽbN */

	return ercd;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
