/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*    ITRONJ[l ^XNO@\                                      */
/*                                                                          */
/*                                  Copyright (C) 1998-2003 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_tsk.h"
#include "knl_mem.h"

/* ^XNO[`̒` */
ER def_tex(
		ID           tskid,
		const T_DTEX *pk_dtex)	/* ^XNO[``ꂽpPbgւ̃|C^ */
{
	T_KERNEL_TCB_RAM   *tcb_ram;
	T_KERNEL_TEXCB_RAM *tex_ram;

	/* ID ͈̓`FbN */
#ifdef HOS_ERCHK_E_ID
	if ( tskid != TSK_SELF && (tskid < KERNEL_TMIN_TSKID || tskid > KERNEL_TMAX_TSKID) )
	{
		return E_ID;	/* sIDԍ */
	}
#endif

	/* p[^[`FbN */
#ifdef HOS_ERCHK_E_RSATR
	if ( pk_dtex != NULL && ((pk_dtex->texatr & ~(TA_HLNG | TA_ASM)) || pk_dtex->texrtn == NULL) )
	{
		return E_RSATR;
	}
#endif

	mknl_loc_sys();	/* VXẽbN */

	/* ^XNRg[ubN擾 */
	if ( tskid == TSK_SELF )
	{
		/* ^XNw莞̕ϊ */
#ifdef HOS_ERCHK_E_ID
		if ( mknl_sns_ctx() )
		{
			/* ^XNReLXg TSK_SELFw͕s */
			mknl_unl_sys();		/* VXẽbN */
			return E_ID;		/* sIDԍ */
		}
#endif
		tcb_ram = kernel_get_run_tsk();
	}
	else
	{
		/* IDԍw莞̕ϊ */
		tcb_ram = KERNEL_TSKID_TO_TCB_RAM(tskid);

		/* IuWFNg݃`FbN */
#ifdef HOS_ERCHK_E_NOEXS
		if ( tcb_ram == NULL )
		{
			mknl_unl_sys();		/* VXẽbN */
			return E_NOEXS;		/* IuWFNg */
		}
#endif
	}

	
	if ( pk_dtex == NULL )	/* NULL̏ꍇ */
	{
		if ( tcb_ram->texcb != NULL )
		{
			/* ɓo^Ă烁J */
			kernel_fre_mem(tcb_ram->texcb);
			tcb_ram->texcb = NULL;
		}
	}
	else	/* o^s */
	{
		/* ɓo^Ă */
		if ( tcb_ram->texcb != NULL )
		{
			/* ̃̂܂ܗp */
			tex_ram = tcb_ram->texcb;
		}
		else
		{
			/* ^XNO[`pm */
			tex_ram = (T_KERNEL_TEXCB_RAM *)kernel_alc_mem(sizeof(T_KERNEL_TEXCB_RAM));
			if ( tex_ram == NULL )
			{
				mknl_unl_sys();		/* VXẽbN */
				return E_NOMEM;		/* s */
			}
			tcb_ram->texcb = tex_ram;
		}
		
		tex_ram->rasptn = 0;
		tex_ram->texrtn = pk_dtex->texrtn;
	}
	
	mknl_unl_sys();		/* VXẽbN */
	
	return E_OK;
}



/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
