/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*    ITRONJ[l ^XNǗ@\                                          */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_tsk.h"
#include "knl_mem.h"



/* ^XN̍폜 */
ER_ID del_tsk(
		ID tskid)	/* 폜Ώۂ̃^XNIDԍ */
{
	T_KERNEL_TCB_RAM *tcb_ram;

	/* ID ͈̓`FbN */
#ifdef HOS_ERCHK_E_ID
	if ( tskid < KERNEL_TMIN_TSKID || tskid > KERNEL_TMAX_TSKID )
	{
		return E_ID;	/* sIDԍ */
	}
#endif

	mknl_loc_sys();	/* VXẽbN */

	/* ID^XNRg[ubNRAM擾 */
	tcb_ram = KERNEL_TSKID_TO_TCB_RAM(tskid);

	/* IuWFNg݃`FbN */
#ifdef HOS_ERCHK_E_NOEXS
	if ( tcb_ram == NULL )
	{
		mknl_unl_sys();	/* VXẽbN */
		return E_NOEXS;	/* IuWFNg */
	}
#endif

	/* IuWFNg̏ԃ`FbN */
#ifdef HOS_ERCHK_E_OBJ
	if ( mknl_get_tskstat(&tcb_ram->mtcb) != TTS_DMT )	/* x~ԂłȂ */
	{
		mknl_unl_sys();	/* VXẽbN */
		return E_OBJ;	/* IuWFNgԃG[ */
	}
#endif
	
	/* ̉ */
	kernel_fre_mem(tcb_ram);

	/* ^XNRg[ubNe[uo^ */
	KERNEL_TSKID_TO_TCB_RAM(tskid) = NULL;


	return E_OK;		/*  */
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
