/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*    ITRONJ[l ^XNO@\                                      */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_tsk.h"
#include "knl_sys.h"



/* ^XNŐ֎~ */
ER dis_tex(void)
{
	T_KERNEL_TCB_RAM *tcb_ram;

	/* ReLXg`FbN */
#ifdef HOS_ERCHK_E_CTX
	if ( sns_ctx() )
	{
		return E_CTX;	/* ReLXgs */
	}
#endif

	tcb_ram = kernel_get_run_tsk();

	mknl_loc_sys();	/* VXẽbN */

	/* IuWFNgԃ`FbN */
#ifdef HOS_ERCHK_E_OBJ
	if ( tcb_ram->texcb == NULL )
	{
		mknl_unl_sys();		/* VXẽbN */
		return E_OBJ;		/* IuWFNgԕs */
	}
#endif

	/* Ő֎~ */
	mknl_dis_tex(&tcb_ram->mtcb);

	mknl_unl_sys();		/* VXẽbN */

	return E_OK;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
