/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*    ITRONJ[l ^XNǗ@\                                          */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_tsk.h"
#include "knl_sys.h"
#include "knl_mem.h"



/* ^XN̏Iƍ폜 */
void exd_tsk(void)
{
	T_KERNEL_TCB_RAM *tcb_ram;
	T_MKNL_TCB *mtcb_run;
	ID tskid;

	/* s^XN̎擾 */
	mtcb_run = mknl_get_run_tsk();

	mknl_loc_sys();	/* VXẽbN */

	/* s^XN̏I */
	mknl_ter_tsk(mtcb_run);

	tcb_ram = KERNEL_STATIC_CAST(T_KERNEL_TCB_RAM, mtcb, mtcb_run);
	tskid = kernel_get_tid(tcb_ram);
	
	/* ̉(VXebN܂ł͉̈Sł邱ƂۏႷ) */
	kernel_fre_mem(tcb_ram);

	/* ^XNRg[ubNe[uo^ */
	KERNEL_TSKID_TO_TCB_RAM(tskid) = NULL;

	/* ^XNfBXpb`̎s */
	mknl_exe_dsp();
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
