/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*    ITRONJ[l ^XNǗ@\                                          */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_tsk.h"



/* ^XN̏I */
void ext_tsk(void)
{
	const T_KERNEL_TCB_ROM *tcb_rom;
	T_KERNEL_TCB_RAM *tcb_ram;
	T_MKNL_TCB *mtcb_run;

	/* s^XN̎擾 */
	mtcb_run = mknl_get_run_tsk();

	mknl_loc_sys();	/* VXẽbN */

	/* s^XN̏I */
	mknl_ter_tsk(mtcb_run);

	tcb_ram = KERNEL_STATIC_CAST(T_KERNEL_TCB_RAM, mtcb, mtcb_run);
	tcb_rom = tcb_ram->tcb_rom;

	/* NL[COĂȂ */
	if ( tcb_ram->actcnt > 0 )
	{
		tcb_ram->actcnt--;	/* L[COZ */

		/* sReLXgo^ */
		mknl_sta_tsk(
				&tcb_ram->mtcb,			/* o^^XN */
				tcb_rom->exinf,			/* ^XN̊g */
				(FP)kernel_task_entry,	/* ^XN̋NԒn */
				tcb_rom->itskpri,		/* ^XN̋NDx */
				tcb_rom->stksz,			/* ^XÑX^bN̈TCY */
				tcb_rom->stk			/* ^XÑX^bN̈̐擪Ԓn */
			);	
		tcb_ram->suscnt = 0;	/* ҂lXgNA */
		tcb_ram->wupcnt = 0;	/* ҂vL[CONA */
	}

	/* ^XNfBXpb`̎s */
	mknl_exe_dsp();
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
