/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*    ITRONJ[l ^XNǗ@\                                          */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_tsk.h"



/* ^XN̏ */
void kernel_ini_tsk(void)
{
	T_KERNEL_TCB_RAM *tcb_ram;
	int i;

	/* TCBRAM̓[̈ɂĂăR[hŏق悢 */
	for ( i = KERNEL_TMIN_TSKID; i <= KERNEL_TMAX_TSKID; i++ )
	{
		tcb_ram = KERNEL_TSKID_TO_TCB_RAM(i);
		if ( tcb_ram != NULL )
		{
			/* ʃJ[l̏ */
			mknl_ini_tsk(&tcb_ram->mtcb);
			
			/* TA_ACT̂̂N */
			if ( tcb_ram->tcb_rom->tskatr & TA_ACT )
			{
				act_tsk(i);
			}
		}
	}
}


/* ^XÑGg[|Cg */
void kernel_task_entry(
		VP_INT exinf)		/* ^XN̊g */
{
	register const T_KERNEL_TCB_ROM *tcb_rom;
	register T_KERNEL_TCB_RAM *tcb_ram;

	/* X^[gAhX̎Zo */
	tcb_ram = KERNEL_STATIC_CAST(T_KERNEL_TCB_RAM, mtcb, mknl_get_run_tsk());
	tcb_rom = tcb_ram->tcb_rom;

	mknl_unl_sys();			/* VXẽbN */

	tcb_rom->task(exinf);	/* ^XNs */

	ext_tsk();	/* ^[͏I */
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
