/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*    ITRONJ[l ^XNǗ@\                                          */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include <string.h>
#include "knl_tsk.h"
#include "knl_mem.h"



/* ^XN̐(J[l) */
ER kernel_cre_tsk(
		ID           tskid,		/* Ώۂ̃^XNIDԍ */
		const T_CTSK *pk_ctsk)	/* ^XNꂽpPbgւ̃|C^ */
{
	T_KERNEL_TCB_RAM *tcb_ram;
	T_KERNEL_TCB_ROM *tcb_rom;
	SIZE memsize;
	UB   *memptr;
	
	/* KvȃTCYvZ */
	memsize = sizeof(T_KERNEL_TCB_RAM) + sizeof(T_KERNEL_TCB_ROM);
	if ( pk_ctsk->stk == NULL )
	{
		memsize += pk_ctsk->stksz;	/* X^bNTCYZ */
	}
	
	/* m */
	memptr = (UB *)kernel_alc_mem(memsize);
#ifdef HOS_ERCHK_E_NOMEM
	if ( memptr == NULL )
	{
		return E_NOMEM;		/* s */
	}
#endif

	/* |C^ݒ */	
	tcb_ram  = (T_KERNEL_TCB_RAM *)memptr;
	memptr  += sizeof(T_KERNEL_TCB_RAM);
	tcb_rom  = (T_KERNEL_TCB_ROM *)memptr;
	if ( pk_ctsk->stk == NULL )
	{
		memptr  += sizeof(T_KERNEL_TCB_ROM);
		tcb_rom->stk = (VP)memptr;
	}
	else
	{
		tcb_rom->stk = pk_ctsk->stk;
	}

	/* ʃJ[l^XN̏ */
	memset(&tcb_ram->mtcb, 0, sizeof(tcb_ram->mtcb));
	mknl_ini_tsk(&tcb_ram->mtcb);

	/* lݒ */
	tcb_ram->actcnt  = 0;					/* NvL[CO */
	tcb_ram->suscnt  = 0;					/* SUSPENDvlXg */
	tcb_ram->wupcnt  = 0;					/* NvL[CO */
	tcb_ram->tcb_rom = tcb_rom;				/* ^XNRg[ubNROMւ̃|C^ */
	tcb_rom->tskatr  = pk_ctsk->tskatr;		/* ^XN */
	tcb_rom->exinf   = pk_ctsk->exinf;		/* ^XN̊g */
	tcb_rom->task    = pk_ctsk->task;		/* ^XN̋NԒn */
	tcb_rom->itskpri = pk_ctsk->itskpri;	/* ^XN̋NDx */
	tcb_rom->stksz   = pk_ctsk->stksz;		/* ^XÑX^bÑTCYioCgj */

	/* ^XNRg[ubNe[uɓo^ */
	KERNEL_TSKID_TO_TCB_RAM(tskid) = tcb_ram;

	/* sԂŐ */
	if ( pk_ctsk->tskatr & TA_ACT )
	{
		/* sReLXgo^ */
		mknl_sta_tsk(
				&tcb_ram->mtcb,			/* o^^XN */
				tcb_rom->exinf,			/* ^XN̊g */
				(FP)kernel_task_entry,	/* ^XN̋NԒn */
				tcb_rom->itskpri,		/* ^XN̋NDx */
				tcb_rom->stksz,			/* ^XÑX^bN̈TCY */
				tcb_rom->stk			/* ^XÑX^bN̈̐擪Ԓn */
			);	
		
		mknl_exe_dsp();		/* ^XNfBXpb`̎s */
		mknl_exe_tex();		/* O̎s */
	}

	return E_OK;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
