/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*    ITRONJ[l ^XNO@\                                      */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_tsk.h"



/* ^XNOGg[|Cg(ʃJ[lĂяo) */
void kernel_tex_entry(void)
{
	T_KERNEL_TCB_RAM   *tcb_ram;
	T_KERNEL_TEXCB_RAM *texcb;
	TEXPTN rasptn;
	
	tcb_ram = kernel_get_run_tsk();
	texcb   = tcb_ram->texcb;
	
	/* ^XNOvNA */
	rasptn = texcb->rasptn;
	texcb->rasptn = 0;
	
	mknl_dis_tex(&tcb_ram->mtcb);	/* ^XNŐ֎~ */
	mknl_unl_sys();					/* VXẽbN */

	texcb->texrtn(rasptn);			/* ^XNO[`̌Ăяo */

	mknl_loc_sys();					/* VXẽbN */
	mknl_ena_tex(&tcb_ram->mtcb);	/* ^XNŐ */
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
