/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*    ITRONJ[l ^XNO@\                                      */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_tsk.h"
#include "knl_sys.h"


/* ^XNO̗v */
ER ras_tex(
		ID     tskid,		/* vΏۂ̃^XNIDԍ */
		TEXPTN rasptn)		/* v^XNÕ^XNOv */
{
	T_KERNEL_TCB_RAM   *tcb_ram;
	T_KERNEL_TEXCB_RAM *texcb;

	/* ID ͈̓`FbN */
	if ( tskid == TSK_SELF )
	{
		/* ReLXg`FbN */
#ifdef HOS_ERCHK_E_ID
		if ( sns_ctx() )
		{
			return E_ID;	/* sIDԍ */
		}
#endif
		tcb_ram = kernel_get_run_tsk();
		texcb = tcb_ram->texcb;
		
		mknl_loc_sys();	/* VXẽbN */
	}
	else
	{
		/* ID ͈̓`FbN */
#ifdef HOS_ERCHK_E_ID
		if ( tskid < KERNEL_TMIN_TSKID || tskid > KERNEL_TMAX_TSKID )
		{
			return  E_ID;	/* sIDԍ */
		}
#endif
		tcb_ram = KERNEL_TSKID_TO_TCB_RAM(tskid);

		mknl_loc_sys();	/* VXẽbN */
	
		/* IuWFNg݃`FbN */
#ifdef HOS_ERCHK_E_NOEXS
		if ( tcb_ram == NULL )
		{
			mknl_unl_sys();		/* VXẽbN */
			return E_NOEXS;		/* IuWFNg */
		}
#endif
		
		texcb = tcb_ram->texcb;
		
		/* IuWFNgԃ`FbN */
#ifdef HOS_ERCHK_E_OBJ
		if ( texcb == NULL || mknl_get_tskstat(&tcb_ram->mtcb) == TTS_DMT )
		{
			mknl_unl_sys();		/* VXẽbN */
			return E_OBJ;		/* IuWFNgԕs */
		}
#endif
	}

	/* O̗v */
	texcb->rasptn = (TEXPTN)(texcb->rasptn | rasptn);
	mknl_ras_tex(&tcb_ram->mtcb);

	mknl_unl_sys();		/* VXẽbN */

	return E_OK;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
