/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*    ITRONJ[l ^XNǗ@\                                          */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_tsk.h"



/* ^XN̏ԎQ(ȈՔ) */
ER ref_tst(
		ID     tskid,
		T_RTST *p_rtst)
{
	T_KERNEL_TCB_RAM *tcb_ram;

	/* ID ͈̓`FbN */
#ifdef HOS_ERCHK_E_ID
	if ( tskid != TSK_SELF && (tskid < KERNEL_TMIN_TSKID || tskid > KERNEL_TMAX_TSKID) )
	{
		return E_ID;	/* sIDԍ */
	}
#endif

	mknl_loc_sys();	/* VXẽbN */

	/* ^XNRg[ubN擾 */
	if ( tskid == TSK_SELF )
	{
		/* ^XNw莞̕ϊ */
#ifdef HOS_ERCHK_E_ID
		if ( mknl_sns_ctx() )
		{
			/* ^XNReLXg TSK_SELFw͕s */
			mknl_unl_sys();		/* VXẽbN */
			return E_ID;		/* sIDԍ */
		}
#endif
		tcb_ram = kernel_get_run_tsk();
	}
	else
	{
		/* ^XNIDw莞̕ϊ */
		tcb_ram = KERNEL_TSKID_TO_TCB_RAM(tskid);

		/* IuWFNg݃`FbN */
#ifdef HOS_ERCHK_E_NOEXS
		if ( tcb_ram == NULL )
		{
			mknl_unl_sys();				/* VXẽbN */
			return (ER_UINT)E_NOEXS;	/* IuWFNg */
		}
#endif
	}

	/* ^XN擾 */
	p_rtst->tskstat = mknl_get_tskstat(&tcb_ram->mtcb);
	p_rtst->tskwait = mknl_get_tskwait(&tcb_ram->mtcb);
	p_rtst->exinf   = tcb_ram->tcb_rom->exinf;

	mknl_unl_sys();	/* VXẽbN */

	return E_OK;	/*  */
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
