/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*    ITRONJ[l ^XNt@\                                      */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_tsk.h"



/* ҂Ԃ̍ĊJ */
ER rsm_tsk(
		ID tskid)	/* ĊJΏۂ̃^XNIDԍ */
{
	T_KERNEL_TCB_RAM *tcb_ram;

	/* ID ͈̓`FbN */
#ifdef HOS_ERCHK_E_ID
	if ( tskid < KERNEL_TMIN_TSKID || tskid > KERNEL_TMAX_TSKID )
	{
		return E_ID;	/* sIDԍ */
	}
#endif

	mknl_loc_sys();	/* VXẽbN */

	tcb_ram = KERNEL_TSKID_TO_TCB_RAM(tskid);

	/* IuWFNg݃`FbN */
#ifdef HOS_ERCHK_E_NOEXS
	if ( tcb_ram == NULL )
	{
		mknl_unl_sys();	/* VXẽbN */
		return E_NOEXS;	/* IuWFNg */
	}
#endif

	/* IuWFNgԃ`FbN */
#ifdef HOS_ERCHK_E_OBJ
	if ( !(mknl_get_tskstat(&tcb_ram->mtcb) & TTS_SUS) )
	{
		/* ҂ԂłȂ */
		mknl_unl_sys();	/* VXẽbN */
		return E_OBJ;	/* IuWFNgԕs */
	}
#endif

	/* ҂lXgĂL[CÔ݌炷 */
	if ( tcb_ram->suscnt > 0 )
	{
		tcb_ram->suscnt--;
		mknl_unl_sys();		/* VXẽbN */
		return E_OK;
	}
	
	/* ^XN̋҂ */
	mknl_rsm_tsk(&tcb_ram->mtcb);
	
	mknl_exe_dsp();		/* ^XNfBXpb`̎s */
	mknl_exe_tex();		/* O̎s */
	
	mknl_unl_sys();	/* VXẽbN */
	
	return E_OK;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
