/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*    ITRONJ[l ^XNt@\                                      */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_tsk.h"



/* ҂Ԃւ̈ڍs */
ER sus_tsk(
		ID tskid)	/* ڍsΏۂ̃^XNIDԍ */
{
	T_KERNEL_TCB_RAM *tcb_ram;

	/* ID ͈̓`FbN */
#ifdef HOS_ERCHK_E_ID
	if ( tskid != TSK_SELF && (tskid < KERNEL_TMIN_TSKID || tskid > KERNEL_TMAX_TSKID) )
	{
		return E_ID;	/* sIDԍ */
	}
#endif

	mknl_loc_sys();	/* VXẽbN */

	/* ^XNRg[ubN擾 */
	if ( tskid == TSK_SELF )
	{
		/* ^XNw莞̕ϊ */
#ifdef HOS_ERCHK_E_ID
		if ( mknl_sns_ctx() )
		{
			/* ^XNReLXg TSK_SELFw͕s */
			mknl_unl_sys();		/* VXẽbN */
			return E_ID;		/* sIDԍ */
		}
#endif
		tcb_ram = kernel_get_run_tsk();
	}
	else
	{
		/* IDԍw莞̕ϊ */
		tcb_ram = KERNEL_TSKID_TO_TCB_RAM(tskid);

		/* IuWFNg݃`FbN */
#ifdef HOS_ERCHK_E_NOEXS
		if ( tcb_ram == NULL )
		{
			mknl_unl_sys();		/* VXẽbN */
			return E_NOEXS;		/* IuWFNg */
		}
#endif
	}

	/* ReLXg`FbN */
#ifdef HOS_ERCHK_E_CTX
	if ( tcb_ram == kernel_get_run_tsk() )
	{
		mknl_unl_sys();		/* VXẽbN */
		return E_CTX;		/* ReLXgs */
	}
#endif

	/* IuWFNgԃ`FbN */
#ifdef HOS_ERCHK_E_OBJ
	if ( mknl_get_tskstat(&tcb_ram->mtcb) == TTS_DMT )
	{
		mknl_unl_sys();		/* VXẽbN */
		return E_OBJ;		/* IuWFNgԕs */
	}
#endif

	/* IuWFNgԔ */
	if ( mknl_get_tskstat(&tcb_ram->mtcb) & TTS_SUS )
	{
		/* L[COI[o[t[`FbN */
#ifdef HOS_ERCHK_E_QOVR
		if ( tcb_ram->suscnt >= TMAX_SUSCNT )
		{
			mknl_unl_sys();	/* VXẽbN */
			return E_QOVR;
		}
#endif
		tcb_ram->suscnt++;
	}
	else
	{
		/* ^XN̋҂ */
		mknl_sus_tsk(&tcb_ram->mtcb);
	}

	mknl_unl_sys();	/* VXẽbN */

	return E_OK;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
