/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*    ITRONJ[l ^XNǗ@\                                          */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_tsk.h"



/* ^XN̋I */
ER ter_tsk(
		ID tskid)	/* IΏۂ̃^XNIDԍ */
{						
	const T_KERNEL_TCB_ROM *tcb_rom;
	T_KERNEL_TCB_RAM *tcb_ram;

	/* ID ͈̓`FbN */
#ifdef HOS_ERCHK_E_ID
	if ( tskid < KERNEL_TMIN_TSKID || tskid > KERNEL_TMAX_TSKID )
	{
		return E_ID;	/* sIDԍ */
	}
#endif

	mknl_loc_sys();	/* VXẽbN */

	/* ID^XNRg[ubNRAM擾 */
	tcb_ram = KERNEL_TSKID_TO_TCB_RAM(tskid);

	/* IuWFNg݃`FbN */
#ifdef HOS_ERCHK_E_NOEXS
	if ( tcb_ram == NULL )
	{
		mknl_unl_sys();	/* VXẽbN */
		return E_NOEXS;	/* IuWFNg */
	}
#endif

	/* T[rXR[sgp`FbN */
#ifdef HOS_ERCHK_E_ILUSE
	if ( mknl_get_run_tsk() == &tcb_ram->mtcb )		/* s̃^XNȂ */
	{
		mknl_unl_sys();	/* VXẽbN */
		return E_ILUSE;	/* T[rXR[sgp */
	}
#endif

	/* IuWFNg̏ԃ`FbN */
#ifdef HOS_ERCHK_E_OBJ
	if ( mknl_get_tskstat(&tcb_ram->mtcb) == TTS_DMT )	/* łɋx~ԂȂ */
	{
		mknl_unl_sys();	/* VXẽbN */
		return E_OBJ;	/* IuWFNgԃG[ */
	}
#endif

	/* s^XN̏I */
	mknl_rmv_tmout(&tcb_ram->mtcb);		/* ^CAEg҂sɂȂĂΉ */
	mknl_ter_tsk(&tcb_ram->mtcb);		/* ^XN폜 */

	/* NL[COĂȂ */
	if ( tcb_ram->actcnt > 0 )
	{
		tcb_rom = tcb_ram->tcb_rom;

		tcb_ram->actcnt--;	/* L[COZ */

		/* sReLXgo^ */
		mknl_sta_tsk(
				&tcb_ram->mtcb,			/* o^^XN */
				tcb_rom->exinf,			/* ^XN̊g */
				(FP)kernel_task_entry,	/* ^XN̋NԒn */
				tcb_rom->itskpri,		/* ^XN̋NDx */
				tcb_rom->stksz,			/* ^XÑX^bN̈TCY */
				tcb_rom->stk			/* ^XÑX^bN̈̐擪Ԓn */
			);	
		tcb_ram->suscnt = 0;	/* ҂lXgNA */
		tcb_ram->wupcnt = 0;	/* ҂vL[CONA */
	}
	
	mknl_exe_dsp();		/* ^XNfBXpb`̎s */
	mknl_exe_tex();		/* O̎s */
	
	mknl_unl_sys();	/* VXẽbN */
	
	return E_OK;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
