/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*    ITRONJ[l ^XNt@\                                      */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_tsk.h"



/* ^XN̋N҂(^CAEg) */
ER tslp_tsk(
			TMO tmout)
{
	T_KERNEL_TCB_RAM *tcb_ram;
	ER ercd;

	/* p[^[`FbN */
#ifdef HOS_ERCHK_E_PAR 
	if ( tmout != TMO_FEVR && tmout < 0 )
	{
		return E_PAR;
	}
#endif

	mknl_loc_sys();	/* VXẽbN */

	/* ReLXg`FbN */
#ifdef HOS_ERCHK_E_CTX
	if ( mknl_sns_wai() )
	{
		mknl_unl_sys();	/* VXẽbN */
		return E_CTX;	/* ReLXgs */
	}
#endif

	/* ^XNRg[ubN擾 */
	tcb_ram = kernel_get_run_tsk();

	/* NvL[CÕ`FbN */
	if ( tcb_ram->wupcnt > 0 )
	{
		tcb_ram->wupcnt--;
		mknl_unl_sys();		/* VXẽbN */
		return E_OK;
	}

	/* |[OwȂ^CAEg */
	if ( tmout == TMO_POL )
	{
		mknl_unl_sys();		/* VXẽbN */
		return E_TMOUT;
	}
	
	/* ҂Ԃɐݒ */
	 mknl_wai_tsk(&tcb_ram->mtcb, TTW_SLP);
	
	/* ^CAEg҂sɒǉ */
	if ( tmout != TMO_FEVR )
	{
		mknl_add_tmout(&tcb_ram->mtcb, (RELTIM)tmout);
	}
	
	ercd = (ER)mknl_exe_dsp();	/* ^XNfBXpb`̎s */
	mknl_exe_tex();				/* O̎s */
	
	mknl_unl_sys();	/* VXẽbN */
	
	return ercd;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
