/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*    ITRONJ[l ^XNt@\                                      */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "knl_tsk.h"



/* ^XN̋N */
ER wup_tsk(ID tskid)
{
	T_KERNEL_TCB_RAM *tcb_ram;

	/* ID ͈̓`FbN */
#ifdef HOS_ERCHK_E_ID
	if ( tskid != TSK_SELF && (tskid < KERNEL_TMIN_TSKID || tskid > KERNEL_TMAX_TSKID) )
	{
		return E_ID;	/* sIDԍ */
	}
#endif

	mknl_loc_sys();	/* VXẽbN */

	/* ^XNRg[ubN擾 */
	if ( tskid == TSK_SELF )
	{
		/* ^XNw莞̕ϊ */
#ifdef HOS_ERCHK_E_ID
		if ( mknl_sns_ctx() )
		{
			/* ^XNReLXg TSK_SELFw͕s */
			mknl_unl_sys();		/* VXẽbN */
			return E_ID;		/* sIDԍ */
		}
#endif
		tcb_ram = kernel_get_run_tsk();
	}
	else
	{
		/* IDԍw莞̕ϊ */
		tcb_ram = KERNEL_TSKID_TO_TCB_RAM(tskid);

		/* IuWFNg݃`FbN */
#ifdef HOS_ERCHK_E_NOEXS
		if ( tcb_ram == NULL )
		{
			mknl_unl_sys();		/* VXẽbN */
			return E_NOEXS;		/* IuWFNg */
		}
#endif
	}

	/* IuWFNg̏ԃ`FbN */
#ifdef HOS_ERCHK_E_OBJ
	if ( mknl_get_tskstat(&tcb_ram->mtcb) == TTS_DMT )
	{
		mknl_unl_sys();	/* VXẽbN */
		return E_OBJ;	/* IuWFNgԃG[ */
	}
#endif

	/* NvL[CÕ`FbN */
	if ( !(mknl_get_tskstat(&tcb_ram->mtcb) & TTS_WAI)
			|| mknl_get_tskwait(&tcb_ram->mtcb) != TTW_SLP )
	{
#ifdef HOS_ERCHK_E_QOVR
		if ( tcb_ram->wupcnt >= TMAX_WUPCNT )
		{
			mknl_unl_sys();	/* VXẽbN */
			return E_QOVR;
		}
#endif
		tcb_ram->wupcnt++;
		mknl_unl_sys();	/* VXẽbN */
		return E_OK;	/* NvL[COďI */
	}
	
	/* ^XNN */
	mknl_rmv_tmout(&tcb_ram->mtcb);			/* ^CAEg҂s񂩂폜 */
	mknl_wup_tsk(&tcb_ram->mtcb, E_OK);		/* ҂ԉ */
	
	mknl_exe_dsp();		/* ^XNfBXpb`̎s */
	mknl_exe_tex();		/* O̎s */
	
	mknl_unl_sys();		/* VXẽbN */
	
	return E_OK;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
