/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*    ʃJ[l ^CAEgL[Ǘ                                     */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "mknl.h"



/* O[oϐ */
T_MKNL_TCB *mknl_timout_head;		/* ^CAEgL[̐擪 */



/* ^CAEgɃ^CeBbN */
void mknl_tic_tmout(
		RELTIM tictim)		/* ǉ^CeBbN */
{
	register T_MKNL_TCB *mtcb;

	/* [JɃRs[ */
	mtcb = mknl_timout_head;

	/* ^CAEgL[Ȃ烊^[ */
	if ( mtcb == NULL )
	{
		return;
	}

	/* ^CAEgL[̏ */
	for ( ; ; )
	{
		/* ^CAEgɒBȂȂ */
		if ( tictim < mtcb->diftim )
		{
			mtcb->diftim -= tictim;		/* ^CAEgԂZ */
			break;
		}
		
		tictim -= mtcb->diftim;			/* ^CeBbNZ */
		
		mknl_wup_tsk(mtcb, E_TMOUT);	/* ^CAEgN */
		mknl_exe_dsp();					/* xfBXpb`\s */
		
		/* L[O */
		if ( mtcb->tm_next == mtcb )	/* Ō̂PȂ */
		{
			/* L[ɂ */
			mtcb->tm_prev = NULL;
			mtcb          = NULL;
			break;
		}
		else
		{
			/* L[O */
			mtcb->tm_next->tm_prev = mtcb->tm_prev;
			mtcb->tm_prev->tm_next = mtcb->tm_next;
			mtcb->tm_prev = NULL;
			mtcb = mtcb->tm_next;
		}

		/* ňxAd荞݂̋@^ */
		mknl_unl_sys();		/* VXẽbN */
		mknl_loc_sys();		/* VXẽbN */
	}
	
	/* ɏ߂ */
	mknl_timout_head = mtcb;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
