/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*    ʃJ[l ^XN                                                 */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "mknl.h"
#include "dsp_hok.h"



/* ^XNfBXpb`̎s */
ER_UINT mknl_exe_dsp(void)
{
	T_HOSPAC_CTXINF *ctxinf_top;
	T_HOSPAC_CTXINF *ctxinf_run;
	T_MKNL_TCB *mtcb_top;
	T_MKNL_TCB *mtcb_run;

	/* ReLXg`FbN */
	if ( mknl_ctx_stat & (MKNL_TSS_INDP | MKNL_TSS_DDSP | MKNL_TSS_DINT) )
	{
		/* fBXpb`s\ԂŖΕۗ */
		mknl_ctx_stat |= MKNL_TSS_DDLY;	/* fBXpb`xtOZbg */
		return E_OK;
	}

	/* ōDx̎s\^XNT */
	mtcb_top = mknl_srh_top();

	mtcb_run = mknl_run_mtcb;	/* ݂̃^XN[Jɑޔ */

	/* s^XNȂ牽Ȃ(AChACh܂ށj */
	if ( mtcb_top == mtcb_run )
	{
		if ( mtcb_run == NULL )
		{
			return E_OK;
		}
		return mtcb_run->ercd;
	}

	/* ACh^XNsłȂ`FbN */
	if ( mtcb_run == NULL )
	{
		/* AChȂAChReLXgݒ */
		ctxinf_run = &mknl_idlctx;
	}
	else
	{
		/* s̃ReLXgݒ */
		ctxinf_run = &mtcb_run->ctxinf;
	}

	/* Ɏs^XN邩ǂ`FbN */
	if ( mtcb_top == NULL )
	{
		/* s悪΃AChReLXgݒ */
		mknl_run_mtcb = NULL;
		ctxinf_top    = &mknl_idlctx;
	}
	else
	{
		/* s̃^XNs^XNƂēo^ */
		mknl_run_mtcb     = mtcb_top;
		mtcb_top->tskstat = TTS_RDY;
		
		/* s̃ReLXgݒ */
		ctxinf_top = &mtcb_top->ctxinf;
	}

	/* ^XNReLXgXCb`s */
	hospac_swi_ctx(ctxinf_run, ctxinf_top);

	_HOS_TSW_HOK();		/* ReLXgXCb`̃tbN */

	if ( mtcb_run == NULL )
	{
		return E_OK;
	}

	return mtcb_run->ercd;
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
