/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*    ʃJ[l ^XN                                                 */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "mknl.h"



/* ^XN̊Jn */
void mknl_sta_tsk(
		T_MKNL_TCB *mtcb,					/* ʃJ[l^XNRg[ubN */
		VP_INT     exinf,					/* ^XN̊g */
		FP         task,					/* ^XN̋NԒn */
		PRI        tskpri,					/* ^XN̋NDx */
		SIZE       stksz,					/* ^XÑX^bN̈̃TCY */
		VP         stk)						/* ^XÑX^bN̈̐擪Ԓn */
{
	/* sReLXg̍쐬 */
	mtcb->data = exinf;
	hospac_cre_ctx(&mtcb->ctxinf, exinf, task, stksz, stk);

	/* ^XN̏Ԑݒ */
	mtcb->tskstat = TTS_RDY;	/* fB[Ԃɐݒ */
	mtcb->texstat = 0;			/* Oԏ */
	mtcb->tskpri  = tskpri;		/* Dxݒ */
	mtcb->tskwait = 0;			/* ҂v */

	/* fB[L[ɐݒ */
	mknl_adf_que(&mknl_rdq_tbl[tskpri - TMIN_TPRI], mtcb);
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
