/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*    vZbTۉR|[lg (Windowsp)                            */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include <stdlib.h>
#include "hospac.h"
#include <tchar.h>


/* ^XN */
typedef struct t_TaskInfo
{
	VP_INT exinf;			/* ^XN̎sp[^ */
	FP     task;			/* ^XN̋NԒn */
} T_TaskInfo;



DWORD WINAPI TaskEntry(LPVOID param);	/* Xbh̊Jn֐ */
void  HookPrimaryThread(void);			/* vC}Xbh̃tbN */

HANDLE hospac_hSem  = NULL;				/* VXe̔rpZ}tH */
BOOL   hospac_blInt = FALSE;			/* 荞ݏtO */

static DWORD  hPrimaryThreadId;			/* vC}XbhID */
static HANDLE hThreadDelete = NULL;		/* 폜Xbhnh */



/* VXȅ */
void hospac_ini_sys(void)
{
	/* vC}XbhID̕ۑ */
	hPrimaryThreadId = GetCurrentThreadId();

	/* 荞݋֎~ɌĂZ}tH̍쐬 */
	hospac_hSem = CreateSemaphore(NULL, 0, 1, NULL);
}


/* 荞݋ */
void hospac_ena_int(void)
{
	if ( !hospac_blInt )
	{
		ReleaseSemaphore(hospac_hSem, 1, NULL);
	}
}


/* 荞݋֎~ */
void hospac_dis_int(void)
{
	if ( !hospac_blInt )
	{
		WaitForSingleObject(hospac_hSem, INFINITE);
	}
}


/* sReLXg̍쐬 */
void hospac_cre_ctx(
		T_HOSPAC_CTXINF *pk_ctxinf,		/* ReLXg쐬AhX */
		VP_INT          exinf,			/* ^XN̎sp[^ */
		FP              task,			/* ^XN̋NԒn */
		SIZE            stksz,			/* X^bN̈̃TCY */
		VP              stk)			/* X^bN̈̐擪Ԓn */
{
	T_TaskInfo *pInfo;

	/* ^XNi[ */
	pInfo = (T_TaskInfo *)GlobalAlloc(GMEM_FIXED, sizeof(T_TaskInfo));
	pInfo->task  = task;
	pInfo->exinf = exinf;
	
	/*  */
	pk_ctxinf->blIntSuspend = FALSE;
	pk_ctxinf->hThread = CreateThread(NULL, 0, TaskEntry, (LPVOID)pInfo,
									CREATE_SUSPENDED, &pk_ctxinf->dwThreadId);
}


/* Xbh̊Jn֐ */
DWORD WINAPI TaskEntry(LPVOID param)
{
	T_TaskInfo Info;

	Info = *(T_TaskInfo *)param;

	GlobalFree((HGLOBAL)param);

	Info.task(Info.exinf);

	return 0;
}


/* sReLXg̍폜 */
void hospac_del_ctx(T_HOSPAC_CTXINF *pk_ctxinf)
{
	if ( GetCurrentThreadId() != pk_ctxinf->dwThreadId )
	{
		/* sXbhłȂΑ폜 */
		TerminateThread(pk_ctxinf->hThread, 0);
	}
	else
	{
		/* sXbhȂ폜\ */
		hThreadDelete = pk_ctxinf->hThread;
	}
}


/* sReLXg̐ؑ */
void hospac_swi_ctx(
		T_HOSPAC_CTXINF *pk_pre_ctxinf,		/* ݂̃ReLXg̕ۑ */
		T_HOSPAC_CTXINF *pk_nxt_ctxinf)		/* VɎsReLXg */
{
	DWORD dwCount;

	if ( hospac_blInt )
	{
		return;
	}

	/* XbhقȂΐ؂ւ */
	if ( pk_nxt_ctxinf != pk_pre_ctxinf )
	{
		/* ؂ւΏۂTXyhł邱ƂmF */
		for ( ; ; )
		{
			/* TXyhJE^𓾂ׂɃTXyhĂ݂ */
			dwCount = SuspendThread(pk_nxt_ctxinf->hThread);
			ResumeThread(pk_nxt_ctxinf->hThread);
			
			/* JE^0łȂ΃TXyhĂ */
			if ( dwCount > 0 )
			{
				break;
			}
			
			/* TXyh܂ő҂ */
			Sleep(1);
		}
		
		/* ؂ւ̃XbhN */
		ResumeThread(pk_nxt_ctxinf->hThread);
		
		/* Z}tHԋp */
		if ( pk_nxt_ctxinf->blIntSuspend )
		{
			pk_nxt_ctxinf->blIntSuspend = FALSE;
			ReleaseSemaphore(hospac_hSem, 1, NULL);
		}
		
		/* vC}XbhĨtbN */
		if ( hPrimaryThreadId == GetCurrentThreadId() )
		{
			HookPrimaryThread();
		}

		/* gTXyh */
		SuspendThread(GetCurrentThread());
	}
	
	/* 폜\̃Xbh΍폜 */
	if ( hThreadDelete != NULL )
	{
		TerminateThread(hThreadDelete, 0);
		CloseHandle(hThreadDelete);
		hThreadDelete = NULL;
	}
}


/* ACh̏ */
void hospac_idle(void)
{
	/* }CRȂȏd̓[hɐ؂ւȂǉ\ */
	
	/* ̃vZXɎs^C~O^ */
	Sleep(1);
}


/* vC}Xbh̃tbN */
void  HookPrimaryThread(void)
{
	/* _CAO\ */
	MessageBox(NULL, _T("OKƏI܂"), _T("Hyper Operationg System V4 for Win32"), MB_OK);

	/* I */
	ExitProcess(0);
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
