/* ------------------------------------------------------------------------ */
/*  Hyper Operating System V4  ITRON4.0dl Real-Time OS                  */
/*    vZbTۉR|[lg (Windowsp)                            */
/*    荞ݏ                                                          */
/*                                                                          */
/*                                  Copyright (C) 1998-2002 by Project HOS  */
/*                                  http://sourceforge.jp/projects/hos/     */
/* ------------------------------------------------------------------------ */


#include "kernel.h"



/* [荞݂̃G~[g(ITRON^XNƂ͖֌W̃XbhĂԂ) */
void hospac_win_int(INTNO intno)
{
	T_HOSPAC_CTXINF *ctxinf;
	T_KERNEL_INTCB intcb;

	/* ͈̓`FbN */
	if ( intno < KERNEL_TMIN_INTNO || intno > KERNEL_TMAX_INTNO )
	{
		return;
	}

	/* Z}tH */
	WaitForSingleObject(hospac_hSem, INFINITE);

	/* sXbhTXyh */
	if ( mknl_run_mtcb != NULL )
	{
		ctxinf = &mknl_run_mtcb->ctxinf;
	}
	else
	{
		ctxinf = &mknl_idlctx;
	}
	SuspendThread(ctxinf->hThread);
	ctxinf->blIntSuspend = TRUE;
	Sleep(0);

	/* 荞݃tOZbg */
	hospac_blInt = TRUE;

	/* [JɃRs[ */
	intcb = KERNEL_INTNO_TO_INTCB(intno);

	/* ^XN(荞݃ReLXgɈڍs) */
	mknl_sta_ind();
	
	/* 荞݂̎s */
	if ( intcb.isr != NULL )
	{
		intcb.isr(intcb.exinf);		/* 荞݃T[rX[`s */
	}

	/* ^XNɈڍs */
	mknl_ext_ind();

	/* 荞݃tONA */
	hospac_blInt = FALSE;

	/* xtONA */
	mknl_ctx_stat = MKNL_TSS_TSK;

	/* ōDx̎s\^XNT */
	mknl_run_mtcb = mknl_srh_top();
	if ( mknl_run_mtcb != NULL )
	{
		ctxinf = &mknl_run_mtcb->ctxinf;
	}
	else
	{
		ctxinf = &mknl_idlctx;
	}

	/* Z}tHԋp */
	if ( ctxinf->blIntSuspend )
	{
		ctxinf->blIntSuspend = FALSE;
		ReleaseSemaphore(hospac_hSem, 1, NULL);
	}

	/* sXbh̕A */
	ResumeThread(ctxinf->hThread);
}


/* ------------------------------------------------------------------------ */
/*  Copyright (C) 1998-2002 by Project HOS                                  */
/* ------------------------------------------------------------------------ */
