#include "htlib2.h"
#include "HtLib.h"
#include "Socket.h"
#include "Header.h"
#include "Thread.h"
#include "Sender.h"

HTLIB_BOOL
M(HTLIB,Init)(HTLIB* o,
			  char* send_buffer, HTLIB_USHORT send_len,
			  char* rec_buffer, HTLIB_USHORT rec_len,
			  HTLIB_ERROR* err)
{
	memset(o, 0, sizeof(HTLIB));

	o->soc = -1;
	o->_rec_buffer = rec_buffer;
	o->_rec_buffer_len = rec_len;
	o->_send_buffer = send_buffer;
	o->_send_buffer_len = send_len;
	
	if (M(Mutex,Init)(&o->_lock, &o->system_errno)==FALSE) {
		*err = HTLIB_E_SYSTEM;
		LOGERR("SYSTEM errno=%d\n", o->system_errno);
		goto mutex_end;
	}
	return TRUE;

mutex_end:
	return FALSE;
}

void
M(HTLIB,Uninit)(HTLIB* o)
{
	M(HTLIB,Close)(o);
	M(Mutex,Uninit)(&o->_lock);
}

BOOL
M(HTLIB,Open)(HTLIB_HANDLE o,
		   const struct sockaddr* addr,
		   socklen_t addr_len,
		   HTLIB_ERROR* err)
{
	if (M(Sender,Open)(o, addr, addr_len, err)==FALSE) {
		return FALSE;
	}
	return TRUE;
}

void
M(HTLIB,Attach)(HTLIB_HANDLE o, int socket)
{
	M(HTLIB,Close)(o);
	o->soc = socket;
	FLAG_SET(FLAG_KEEP_ALIVE, o->_flags);	
}

void
M(HTLIB,Close)(HTLIB_HANDLE o)
{
	M(Sender,Close(o));
}


BOOL
M(HTLIB,CheckCanceled)(HTLIB* o, HTLIB_ERROR* err)
{
	int canceled;
	M(Mutex,Lock)(&o->_lock);
	canceled = o->_is_canceled;
	M(Mutex,Unlock)(&o->_lock);

	if (canceled) {
		*err = HTLIB_E_CANCELED;
		LOGWARN("canceled\n");
		return FALSE;
	}
	return TRUE;
}

void
M(HTLIB,Cancel)(HTLIB* o, BOOL trueIfCancel)
{
	LOGERR("HTLIB_Cancel: %d\n", trueIfCancel);
	M(Mutex,Lock)(&o->_lock);
	o->_is_canceled = trueIfCancel;
	M(Mutex,Unlock)(&o->_lock);
}





