#include "htlib2.h"
#include "Date.h"

void
M(Date,Set)(char* buf30, const time_t* tm)
{
	struct tm gmt;
	time_t now;

	if (tm == NULL) {
		time(&now);
		tm = &now;
	}
	gmtime_r(tm, &gmt);

	static const char* s_day[] = {
		"Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat",
	};
	static const char* s_mon[] = {
		NULL,
		"Jan", "Feb", "Mar", "Apr", "May", "Jun",
		"Jul", "Aug", "Sep", "Oct", "Nov", "Dec",
	};

	/* ex) "Sun, 19 Apr 2009 06:14:33 GMT" */
	snprintf(buf30, 30,
			 "%s, %02d %s %4d %02d:%02d:%02d GMT",
			 s_day[gmt.tm_wday], gmt.tm_mday, s_mon[gmt.tm_mon],
			 gmt.tm_year + 1900,
			 gmt.tm_hour, gmt.tm_min, gmt.tm_sec);
}
