#include "test.h"
#include "chead.h"

#define HHMAX 30

static HTLIB_ERROR err;
static HTLIB_Header hh[HHMAX];
static HTLIB_USHORT hhlen;
static int status;

static const char* id = NULL;

static BOOL
chkNoHeader(HTLIB_HANDLE h, const char* name)
{
	return checkNoHeader(h, hh, hhlen, id, name);
}
static BOOL
chkHeader(HTLIB_HANDLE h, const char* name, const char* value)
{
	return checkHeader(h, hh, hhlen, id, name, value);
}
static BOOL
chkNotHeader(HTLIB_HANDLE h, const char* name, const char* value)
{
	return checkNotHeader(h, hh, hhlen, id, name, value);
}
static char body[10000];

static void
test1(HTLIB_HANDLE h, const char* path)
{
	if (HTLIB_SendRequest(h, -1, "HEAD", URLBASE "/head/200", NULL, 0,
						  NULL, 0, &err)==FALSE) {
		FAIL(id, "SendRequest");
		return;
	}
	hhlen = HHMAX;
	if ((status=HTLIB_ReceiveResponse(h, 2000, hh, &hhlen, NULL, &err))!=200) {
		FAIL(id, "status=%d", status);
		return;
	}
	if (chkHeader(h, "Server", "tests/1.0")==FALSE) {
		return;
	}
	if (chkHeader(h, "Content-Length", "5")==FALSE) {
		return;
	}
	if (chkHeader(h, "Content-Type", "text/plain")==FALSE) {
		return;
	}

	int len;
	if ((len=HTLIB_ReceiveBody(h, 2000, body, sizeof(body), &err))!=0) {
		FAIL(id, "%d must be 0", len);
		return;
	}
	SUCCEED(id);
}	
static void
test2(HTLIB_HANDLE h, const char* path)
{
	if (HTLIB_SendRequest(h, -1, "HEAD", URLBASE "/head/chunk", NULL, 0,
						  NULL, 0, &err)==FALSE) {
		FAIL(id, "SendRequest");
		return;
	}
	hhlen = HHMAX;
	if ((status=HTLIB_ReceiveResponse(h, 2000, hh, &hhlen, NULL, &err))!=200) {
		FAIL(id, "status=%d", status);
		return;
	}
	if (chkHeader(h, "Server", "tests/1.0")==FALSE) {
		return;
	}
	if (chkHeader(h, "Transfer-Encoding", "chunked")==FALSE) {
		return;
	}
	if (chkNoHeader(h, "Content-Length")==FALSE) {
		return;
	}
	if (chkHeader(h, "Content-Type", "text/plain")==FALSE) {
		return;
	}

	int len;
	if ((len=HTLIB_ReceiveBody(h, 2000, body, sizeof(body), &err))!=0) {
		FAIL(id, "%d must be 0", len);
		return;
	}
	SUCCEED(id);
}	
static void
test3(HTLIB_HANDLE h, const char* path)
{
	if (HTLIB_SendRequest(h, -1, "HEAD", URLBASE "/head/404", NULL, 0,
						  NULL, 0, &err)==FALSE) {
		FAIL(id, "SendRequest");
		return;
	}
	hhlen = HHMAX;
	if ((status=HTLIB_ReceiveResponse(h, 2000, hh, &hhlen, NULL, &err))!=404) {
		FAIL(id, "status=%d", status);
		return;
	}
	if (chkHeader(h, "Server", "tests/1.0")==FALSE) {
		return;
	}
	if (chkNoHeader(h, "Transfer-Encoding")==FALSE) {
		return;
	}
	if (chkHeader(h, "Content-Length", "6")==FALSE) {
		return;
	}
	if (chkHeader(h, "Content-Type", "text/plain")==FALSE) {
		return;
	}

	int len;
	if ((len=HTLIB_ReceiveBody(h, 2000, body, sizeof(body), &err))!=0) {
		FAIL(id, "%d must be 0", len);
		return;
	}
	SUCCEED(id);
}	

static BOOL
test4sub(HTLIB_HANDLE h, const char* path)
{
	if (HTLIB_SendRequest(h, -1, "HEAD", path, NULL, 0,
						  "12345", 5,
						  &err)==FALSE) {
		FAIL(id, "SendRequest");
		return FALSE;
	}
	hhlen = HHMAX;
	if ((status=HTLIB_ReceiveResponse(h, 2000, hh, &hhlen, NULL, &err))!=200) {
		FAIL(id, "status=%d", status);
		return FALSE;
	}
	if (chkHeader(h, "Server", "tests/1.0")==FALSE) {
		return FALSE;
	}
	if (chkNoHeader(h, "Transfer-Encoding")==FALSE) {
		return FALSE;
	}
	if (chkHeader(h, "Content-Length", "5")==FALSE) {
		return FALSE;
	}
	if (chkHeader(h, "Content-Type", "application/octet-stream")==FALSE) {
		return FALSE;
	}

	int len;
	if ((len=HTLIB_ReceiveBody(h, 2000, body, sizeof(body), &err))!=0) {
		FAIL(id, "%d must be 0", len);
		return FALSE;
	}
	return TRUE;
}	
static void
test4(HTLIB_HANDLE h, const char* path)
{
	if (test4sub(h, URLBASE "/head/body1")==FALSE) {
		return;
	}
	if (chkNotHeader(h, "X-Seq", "1")==FALSE) {
		return;
	}
	if (chkHeader(h, "X-Body", "body1")==FALSE) {
		return;
	}
	if (test4sub(h, URLBASE "/head/body2")==FALSE) {
		return;
	}
	if (chkHeader(h, "X-Seq", "1")==FALSE) {
		return;
	}
	if (chkHeader(h, "X-Body", "body2")==FALSE) {
		return;
	}
	SUCCEED(id);
}

void
testHead(HTLIB_HANDLE h)
{
	static struct {
		const char* id;
		const char* path;
		void(*func)(HTLIB_HANDLE, const char* path);
	} ff[] = {
		{ "HEAD-1(C)", "/head/200", test1 },
		{ "HEAD-2(C)", "/head/chunk", test2 },
		{ "HEAD-3(C)", "/head/404", test3 },
		{ "HEAD-4(C)", "/head/body1", test4 },
	};
	int i;
	for (i=0; i<sizeof(ff)/sizeof(ff[0]); i++) {
		id = ff[i].id;
		printf("Test %s...\n", id);
		ff[i].func(h, ff[i].path);
	}
}

