#include "server.h"
#include "sget.h"

static const char* id = NULL;

static BOOL
checkCommon(HTLIB_HANDLE h,
			HTLIB_Header* hh, short hlen, const char* ua)
{
	HTLIB_ERROR err = 0;
	
	if (ua == NULL) {
		ua = "testc/1.0";
	}
	int i;
	if ((i=HTLIB_Find(hh, hlen, "User-Agent"))==-1) {
		FAIL(id, "no User-Agent");
		return FALSE;
	}
	if (strcmp(hh[i].value, ua)!=0) {
		FAIL(id, "%s must be %s", hh[i].value, ua);
		return FALSE;
	}
	return TRUE;
}
static BOOL
checkHost(HTLIB_HANDLE h, HTLIB_Header* hh, short hlen, const char* host)
{
	int i;
	HTLIB_ERROR err = 0;
	
	if (host == NULL) {
		host = "localhost:8000";
	}
	if ((i=HTLIB_Find(hh, hlen, "Host"))==-1) {
		FAIL(id, "no Host");
		return FALSE;
	}
	if (strcmp(hh[i].value, host)!=0) {
		FAIL(id, "%s must be %s", hh[i].value, host);
		return FALSE;
	}
	return TRUE;
}

static BOOL
test1(HTLIB_HANDLE h,
	  HTLIB_Header* hh, short hlen, int seq)
{
	HTLIB_ERROR err;

	if (checkCommon(h, hh, hlen, NULL)==FALSE) {
		return FALSE;
	}
	if (checkHost(h, hh, hlen, NULL)==FALSE) {
		return FALSE;
	}

	HTLIB_Header resh = {
		"Content-Type", "text/plain", 0, NULL,
	};

	if (HTLIB_SendResponse(h, -1, 200, NULL, &resh, 1, NULL, 5,
						   &err)==FALSE) {
		FAIL(id, "SendResponse");
		return FALSE;
	}
	if (HTLIB_SendBody(h, -1, "index1", 5, &err)==FALSE) {
		FAIL(id, "SendBody");
		return FALSE;
	}
	SUCCEED(id);
	return TRUE;
}
static BOOL
test2(HTLIB_HANDLE h,
	  HTLIB_Header* hh, short hlen, int seq)
{
	HTLIB_ERROR err;

	if (checkCommon(h, hh, hlen, NULL)==FALSE) {
		return FALSE;
	}
	if (checkHost(h, hh, hlen, NULL)==FALSE) {
		return FALSE;
	}

	HTLIB_Header resh = {
		"Content-Type", "application/octet-stream", 0, NULL,
	};

	if (HTLIB_SendResponse(h, -1, 200, NULL, &resh, 1, "123\0005", 5,
						   &err)==FALSE) {
		FAIL(id, "");
		return FALSE;
	}
	SUCCEED(id);
	return TRUE;
}
static BOOL
test3(HTLIB_HANDLE h,
	  HTLIB_Header* hh, short hlen, int seq)
{
	HTLIB_ERROR err;

	if (checkCommon(h, hh, hlen, NULL)==FALSE) {
		return FALSE;
	}
	if (checkHost(h, hh, hlen, NULL)==FALSE) {
		return FALSE;
	}

	HTLIB_Header resh = {
		"Content-Type", "text/plain", 0, NULL,
	};

	if (HTLIB_SendResponse(h, -1, 200, NULL, &resh, 1, NULL, 6,
						   &err)==FALSE) {
		FAIL(id, "SendResponse");
		return FALSE;
	}
	if (HTLIB_SendBody(h, -1, "err404", 6, &err)==FALSE) {
		FAIL(id, "SendBody");
	}
	SUCCEED(id);
	return TRUE;
}

static BOOL
test4(HTLIB_HANDLE h,
	  HTLIB_Header* hh, short hlen, int seq)
{
	HTLIB_ERROR err;

	if (checkCommon(h, hh, hlen, NULL)==FALSE) {
		return FALSE;
	}
	if (checkHost(h, hh, hlen, NULL)==FALSE) {
		return FALSE;
	}

	HTLIB_Header resh = {
		"Content-Type", "text/plain", 0, NULL,
	};

	if (HTLIB_SendResponse(h, -1, 200, NULL, &resh, 1, NULL, -1,
						   &err)==FALSE) {
		FAIL(id, "SendResponse");
		return FALSE;
	}
	if (sendBodyChunk(h, -1, "123456", 5, &err)==FALSE) {
		FAIL(id, "SendBodyCHunk");
		return FALSE;
	}
	if (sendBodyChunk(h, -1, "67890", 5, &err)==FALSE) {
		FAIL(id, "SendBodyCHunk");
		return FALSE;
	}
	if (HTLIB_SendBody(h, -1, NULL, 0, &err)==FALSE) {
		FAIL(id, "SendBody NULL");
		return FALSE;
	}
	SUCCEED(id);
	return TRUE;
}

static BOOL
test5(HTLIB_HANDLE h,
	  HTLIB_Header* hh, short hlen, int seq)
{
	HTLIB_ERROR err;

	if (checkCommon(h, hh, hlen, NULL)==FALSE) {
		return FALSE;
	}
	if (checkHost(h, hh, hlen, NULL)==FALSE) {
		return FALSE;
	}

	HTLIB_Header resh[] = {
		{ "Content-Type", "application/octet-stream", 0, NULL, },
		{ "Connection", "close", 0, NULL, },
	};

	if (HTLIB_SendResponse(h, -1, 200, NULL, resh, 2, NULL, -1,
						   &err)==FALSE) {
		FAIL(id, "SendResponse");
		return FALSE;
	}
	if (HTLIB_SendBody(h, -1, "123\0005", 5, &err)==FALSE) {
		FAIL(id, "SendBody NULL");
	}
	HTLIB_Close(h);
	SUCCEED(id);
	return TRUE;
}

static BOOL
test6(HTLIB_HANDLE h,
	  HTLIB_Header* hh, short hlen, int seq)
{
	HTLIB_ERROR err;

	if (checkCommon(h, hh, hlen, NULL)==FALSE) {
		return FALSE;
	}
	if (checkHost(h, hh, hlen, NULL)==FALSE) {
		return FALSE;
	}
	if (checkHeader(h, hh, hlen, id, "Connection", "close")==FALSE) {
		return FALSE;
	}

	HTLIB_Header resh = {
		"Content-Type", "text/plain", 0, NULL,
	};

	if (HTLIB_SendResponse(h, -1, 200, NULL, &resh, 1, NULL, -1,
						   &err)==FALSE) {
		FAIL(id, "SendResponse");
		return FALSE;
	}
	/* sendBodyChunk, but just end by close */
	if (sendBodyChunk(h, -1, "123456", 5, &err)==FALSE) {
		FAIL(id, "SendBodyCHunk");
		return FALSE;
	}
	/* sendBodyChunk, but just end by close */
	if (sendBodyChunk(h, -1, "67890", 5, &err)==FALSE) {
		FAIL(id, "SendBodyCHunk");
		return FALSE;
	}
	/* sendBodyChunk NUL, but close */
	if (HTLIB_SendBody(h, -1, NULL, 0, &err)==FALSE) {
		FAIL(id, "SendBody NULL");
		return FALSE;
	}
	SUCCEED(id);
	return TRUE;
}

static BOOL
test7sub(HTLIB_HANDLE h,
	  HTLIB_Header* hh, short hlen, int seq)
{
	HTLIB_ERROR err;

	if (checkCommon(h, hh, hlen, NULL)==FALSE) {
		return FALSE;
	}
	if (checkHost(h, hh, hlen, NULL)==FALSE) {
		return FALSE;
	}

	char cseq[8];
	sprintf(cseq, "%d", seq);
	
	HTLIB_Header resh[] = {
		{ "Content-Type", "application/octet-stream", 0, NULL, },
		{ "Connection", "close", 0, NULL, },
		{ "X-Seq", cseq, 0, NULL, },
	};

	if (HTLIB_SendResponse(h, -1, 200, NULL, resh, 3, "123\0005", 5,
						   &err)==FALSE) {
		FAIL(id, "");
		return FALSE;
	}
	return TRUE;
}

static BOOL
test7_1(HTLIB_HANDLE h,
	  HTLIB_Header* hh, short hlen, int seq)
{
	if (test7sub(h, hh, hlen, seq)==FALSE) {
		return FALSE;
	}
	HTLIB_Close(h);
	sleep(1);
	return TRUE;
}
static BOOL
test7_2(HTLIB_HANDLE h,
	  HTLIB_Header* hh, short hlen, int seq)
{
	if (test7sub(h, hh, hlen, seq)==FALSE) {
		return FALSE;
	}
	SUCCEED(id);
	return TRUE;
}

static BOOL
test8sub(HTLIB_HANDLE h,
		 HTLIB_Header* hh, short hlen, int seq, const char* body)
{
	HTLIB_ERROR err;

	if (checkCommon(h, hh, hlen, NULL)==FALSE) {
		return FALSE;
	}
	if (checkHost(h, hh, hlen, NULL)==FALSE) {
		return FALSE;
	}
	if (checkHeader(h, hh, hlen, id, "Content-Length", "5")==FALSE) {
		return FALSE;
	}

	char reqbody[1000];
	int len;
	if ((len=receiveBody(h, reqbody, sizeof(reqbody), id))!=5) {
		FAIL(id, "%d must be 5", len);
		return FALSE;
	}
	if (memcmp(reqbody, "12345", 5)!=0) {
		FAIL(id, "%.*s must be 12345", 5, reqbody);
		return FALSE;
	}

	char cseq[8];
	sprintf(cseq, "%d", seq);
	
	HTLIB_Header resh[] = {
		{ "Content-Type", "application/octet-stream", 0, NULL, },
		{ "X-Seq", cseq, 0, NULL, },
	};

	if (HTLIB_SendResponse(h, -1, 200, NULL, resh, 2, body, 5,
						   &err)==FALSE) {
		FAIL(id, "");
		return FALSE;
	}
	return TRUE;
}

static BOOL
test8_1(HTLIB_HANDLE h, HTLIB_Header* hh, short hlen, int seq)
{
	if (test8sub(h, hh, hlen, seq, "body1")==FALSE) {
		return FALSE;
	}
	return TRUE;
}
static BOOL
test8_2(HTLIB_HANDLE h, HTLIB_Header* hh, short hlen, int seq)
{
	if (test8sub(h, hh, hlen, seq, "body2")==FALSE) {
		return FALSE;
	}
	SUCCEED(id);
	return TRUE;
}

BOOL
testGet(HTLIB_HANDLE h, const char* uri, const char* method,
		HTLIB_Header* hh, short hlen, int seq)
{
	HTLIB_ERROR err;

	static struct {
		const char* id;
		const char* path;
		BOOL(*func)(HTLIB_HANDLE, HTLIB_Header*, short hlen, int seq);
	} ff[] = {
		{ "GET-1(S)", "/", test1 },
		{ "GET-2(S)", "/get/200", test2 },
		{ "GET-3(S)", "/get/404", test3 },
		{ "GET-4(S)", "/get/chunk", test4 },
		{ "GET-5(S)", "/get/endbyclose1", test5 },
		{ "GET-6(S)", "/get/endbyclose2", test6 },
		{ "GET-7(S)", "/get/close1", test7_1 },
		{ "GET-7(S)", "/get/close2", test7_2 },
		{ "GET-8(S)", "/get/body1", test8_1 },
		{ "GET-8(S)", "/get/body2", test8_2 },
	};

	int i;
	for (i=0; i<sizeof(ff)/sizeof(ff[0]); i++) {
		if (strcmp(uri, ff[i].path)==0) {
			id = ff[i].id;
			if (strcmp(method, "GET")!=0) {
				FAIL(id, "%s must be GET", method);
				return FALSE;
			}
			return ff[i].func(h, hh, hlen, seq);
		}
	}

	FAIL("GET-X", "not implemented for %s", uri);
	return FALSE;
}

