#include "server.h"
#include "shttp.h"

static const char* id = NULL;

static BOOL
checkCommon(HTLIB_HANDLE h,
			HTLIB_Header* hh, short hlen, const char* ua,
			const char* method, const char* method2)
{
	HTLIB_ERROR err = 0;
	
	if (strcmp(method, method2)!=0) {
		FAIL(id, "%s must be %s", method, method2);
		return FALSE;
	}

	if (ua == NULL) {
		ua = "testc/1.0";
	}
	int i;
	if ((i=HTLIB_Find(hh, hlen, "User-Agent"))==-1) {
		FAIL(id, "no User-Agent");
		return FALSE;
	}
	if (strcmp(hh[i].value, ua)!=0) {
		FAIL(id, "%s must be %s", hh[i].value, ua);
		return FALSE;
	}
	return TRUE;
}
static BOOL
checkHost(HTLIB_HANDLE h, HTLIB_Header* hh, short hlen, const char* host)
{
	int i;
	HTLIB_ERROR err = 0;
	
	if (host == NULL) {
		host = "localhost:8000";
	}
	if ((i=HTLIB_Find(hh, hlen, "Host"))==-1) {
		FAIL(id, "no Host");
		return FALSE;
	}
	if (strcmp(hh[i].value, host)!=0) {
		FAIL(id, "%s must be %s", hh[i].value, host);
		return FALSE;
	}
	return TRUE;
}

static BOOL
test1(HTLIB_HANDLE h,
	  HTLIB_Header* hh, short hlen, int seq, const char* method,
		int a)
{
	HTLIB_ERROR err;

	if (checkCommon(h, hh, hlen, "tcp/1.0", method, "GET")==FALSE) {
		return FALSE;
	}
	if (checkHost(h, hh, hlen, "localhost:8000")==FALSE) {
		return FALSE;
	}

	HTLIB_Header resh[] = {
		{ "Content-Type", "text/plain", 0, NULL, },
	};

	if (HTLIB_SendResponse(h, -1, 200, NULL,
						   resh, sizeof(resh)/sizeof(resh[0]),
						   NULL, 5,
						   &err)==FALSE) {
		FAIL(id, "SendResponse");
		return FALSE;
	}
	if (HTLIB_SendBody(h, -1, "absok", 5, &err)==FALSE) {
		FAIL(id, "SendBody");
		return FALSE;
	}
	SUCCEED(id);
	return TRUE;
}
static BOOL
test2(HTLIB_HANDLE h,
	  HTLIB_Header* hh, short hlen, int seq, const char* method,
		int a)
{
	HTLIB_ERROR err;

	if (checkCommon(h, hh, hlen, "tcp/1.0", method, "GET")==FALSE) {
		return FALSE;
	}
	if (checkHost(h, hh, hlen, "localhost:8000")==FALSE) {
		return FALSE;
	}

	HTLIB_Header resh[] = {
		{ "Content-Type", "text/plain", 0, NULL, },
	};

	if (HTLIB_SendResponse(h, -1, 200, NULL,
						   resh, sizeof(resh)/sizeof(resh[0]),
						   NULL, 5,
						   &err)==FALSE) {
		FAIL(id, "SendResponse");
		return FALSE;
	}
	if (HTLIB_SendBody(h, -1, "absok", 5, &err)==FALSE) {
		FAIL(id, "SendBody");
		return FALSE;
	}
	SUCCEED(id);
	return TRUE;
}

static BOOL
test3(HTLIB_HANDLE h,
	  HTLIB_Header* hh, short hlen, int seq, const char* method,
		int a)
{
	HTLIB_ERROR err;

	if (checkCommon(h, hh, hlen, NULL, method, "POST")==FALSE) {
		return FALSE;
	}
	if (checkHost(h, hh, hlen, NULL)==FALSE) {
		return FALSE;
	}
	if (checkHeader(h, hh, hlen, id, "Transfer-Encoding", "chunked")==FALSE) {
		return FALSE;
	}
	if (checkHeader(h, hh, hlen, id, "Content-Type", "text/plain")==FALSE) {
		return FALSE;
	}
	if (checkHeader(h, hh, hlen, id, "Expect", "100-continue")==FALSE) {
		return FALSE;
	}

	if (HTLIB_SendResponse(h, -1, 100, NULL,
						   NULL, 0,
						   NULL, 0,
						   &err)==FALSE) {
		FAIL(id, "SendResponse");
		return FALSE;
	}

	char body[1000];
	int len;
	if ((len=receiveBody(h, body, sizeof(body), id))!=10) {
		FAIL(id, "%d must be 10", len);
		return FALSE;
	}
	if (memcmp(body, "1234567890", len)!=0) {
		FAIL(id, "%.*s must be 1234567890", len, body);
		return FALSE;
	}
	
	HTLIB_Header resh[] = {
		{ "Content-Type", "text/plain", 0, NULL, },
	};

	if (HTLIB_SendResponse(h, -1, 200, NULL,
						   resh, sizeof(resh)/sizeof(resh[0]),
						   NULL, -1,
						   &err)==FALSE) {
		FAIL(id, "SendResponse");
		return FALSE;
	}
	if (HTLIB_SendBody(h, -1, NULL, 5, &err)==FALSE) {
		FAIL(id, "SendBody");
		return FALSE;
	}
	if (HTLIB_SendBody(h, -1, "12345", 5, &err)==FALSE) {
		FAIL(id, "SendBody");
		return FALSE;
	}
	if (HTLIB_SendBody(h, -1, NULL, 5, &err)==FALSE) {
		FAIL(id, "SendBody");
		return FALSE;
	}
	if (HTLIB_SendBody(h, -1, "67890", 5, &err)==FALSE) {
		FAIL(id, "SendBody");
		return FALSE;
	}
	if (HTLIB_SendBody(h, -1, NULL, 0, &err)==FALSE) {
		FAIL(id, "SendBody");
		return FALSE;
	}
	SUCCEED(id);
	return TRUE;
}
static BOOL
test4_1(HTLIB_HANDLE h,
		 HTLIB_Header* hh, short hlen, int seq, const char* method,
		int a)
{
	HTLIB_ERROR err;

	if (checkCommon(h, hh, hlen, NULL, method, "GET")==FALSE) {
		return FALSE;
	}
	if (checkHost(h, hh, hlen, "localhost:8000")==FALSE) {
		return FALSE;
	}

	char cseq[8];
	sprintf(cseq, "%d", seq);
	HTLIB_Header resh[] = {
		{ "Content-Type", "text/plain", 0, NULL },
		{ "X-Seq", cseq, 0, NULL },
	};

	if (HTLIB_SendResponse(h, -1, 200, NULL,
						   resh, sizeof(resh)/sizeof(resh[0]),
						   NULL, 8,
						   &err)==FALSE) {
		FAIL(id, "SendResponse");
		return FALSE;
	}
	if (HTLIB_SendBody(h, -1, "reconok1", 8, &err)==FALSE) {
		FAIL(id, "SendBody");
		return FALSE;
	}
	return FALSE; /* to close */
}
static BOOL
test4_2(HTLIB_HANDLE h,
		 HTLIB_Header* hh, short hlen, int seq, const char* method,
		int a)
{
	HTLIB_ERROR err;

	if (checkCommon(h, hh, hlen, NULL, method, "GET")==FALSE) {
		return FALSE;
	}
	if (checkHost(h, hh, hlen, "localhost:8000")==FALSE) {
		return FALSE;
	}

	char cseq[8];
	sprintf(cseq, "%d", seq);
	
	HTLIB_Header resh[] = {
		{ "Content-Type", "text/plain", 0, NULL },
		{ "X-Seq", cseq, 0, NULL },
	};

	if (HTLIB_SendResponse(h, -1, 200, NULL,
						   resh, sizeof(resh)/sizeof(resh[0]),
						   NULL, 8,
						   &err)==FALSE) {
		FAIL(id, "SendResponse");
		return FALSE;
	}
	if (HTLIB_SendBody(h, -1, "reconok2", 8, &err)==FALSE) {
		FAIL(id, "SendBody");
		return FALSE;
	}
	SUCCEED(id);
	return TRUE;
}
static BOOL
test5(HTLIB_HANDLE h,
	  HTLIB_Header* hh, short hlen, int seq, const char* method,
		int a)
{
	HTLIB_ERROR err;

	if (checkCommon(h, hh, hlen, NULL, method, "POST")==FALSE) {
		return FALSE;
	}
	if (checkHost(h, hh, hlen, "localhost:8000")==FALSE) {
		return FALSE;
	}

	if (checkHeader(h, hh, hlen, id, "Content-Type", "text/plain")==FALSE) {
		return FALSE;
	}
	
	HTLIB_Header resh[] = {
		{ "Content-Type", "text/plain", 0, NULL },
	};

	if (HTLIB_SendResponse(h, -1, 200, NULL,
						   resh, sizeof(resh)/sizeof(resh[0]),
						   NULL, 8,
						   &err)==FALSE) {
		FAIL(id, "SendResponse");
		return FALSE;
	}
	if (HTLIB_SendBody(h, -1, "reconng1", 8, &err)==FALSE) {
		FAIL(id, "SendBody");
		return FALSE;
	}
	SUCCEED(id);
	return FALSE; /* to close */
}
static BOOL
test6(HTLIB_HANDLE h,
	  HTLIB_Header* hh, short hlen, int seq, const char* method,
		int a)
{
	HTLIB_ERROR err;

	if (checkCommon(h, hh, hlen, NULL, method, "GET")==FALSE) {
		return FALSE;
	}
	if (checkHost(h, hh, hlen, "localhost:8000")==FALSE) {
		return FALSE;
	}
	
	HTLIB_Header resh[] = {
		{ "Content-Type", "text/plain", 0, NULL },
	};

	if (HTLIB_SendResponse(h, -1, 200, NULL,
						   resh, sizeof(resh)/sizeof(resh[0]),
						   NULL, 6,
						   &err)==FALSE) {
		FAIL(id, "SendResponse");
		return FALSE;
	}
	if (HTLIB_SendBody(h, -1, "crlfok", 6, &err)==FALSE) {
		FAIL(id, "SendBody");
		return FALSE;
	}
	SUCCEED(id);
	return TRUE;
}
static BOOL
test101(HTLIB_HANDLE h,
		HTLIB_Header* hh, short hlen, int seq, const char* method,
		int a)
{
	HTLIB_ERROR err;

	char cseq[8];
	sprintf(cseq, "%d", seq);
	HTLIB_Header resh[] = {
		{ "Content-Type", "text/plain", 0, NULL },
		{ "X-Seq", cseq, 0, NULL },
	};

	if (HTLIB_SendResponse(h, -1, 200, NULL,
						   resh, sizeof(resh)/sizeof(resh[0]),
						   "keepalive", 9,
						   &err)==FALSE) {
		FAIL(id, "SendResponse");
		return FALSE;
	}
	if (a == 3) {
		SUCCEED(id);
	}
	return TRUE;
}

static BOOL
test091(HTLIB_HANDLE h,
		HTLIB_Header* hh, short hlen, int seq, const char* method,
		int a)
{
	HTLIB_ERROR err;

	char cseq[8];
	sprintf(cseq, "%d", seq);
	HTLIB_Header resh[] = {
		{ "Content-Type", "text/plain", 0, NULL },
		{ "X-Seq", cseq, 0, NULL },
	};

	if (HTLIB_SendResponse(h, -1, 200, NULL,
						   resh, sizeof(resh)/sizeof(resh[0]),
						   NULL, 0,
						   &err)!=FALSE||
		err != HTLIB_E_HTTP09) {
		FAIL(id, "why not HTTP0.9?");
		return FALSE;
	}
	if (HTLIB_SendBody(h, -1, "http09", 6, &err)==FALSE) {
		FAIL(id, "SendBody");
		return FALSE;
	}

	HTLIB_Header header_buffer[30];
	HTLIB_USHORT blen = 30;
	if (HTLIB_ReceiveRequest(h, 1000, &method, header_buffer, &blen, NULL,
							 &err)!=FALSE ||
		err != HTLIB_E_HTTP09) {
		FAIL(id, "Why not HTTP09?");
	}
	HTLIB_Close(h);

	SUCCEED(id);

	return FALSE;
}

BOOL
testHttp(HTLIB_HANDLE h, const char* uri, const char* method,
		HTLIB_Header* hh, short hlen, int seq)
{
	HTLIB_ERROR err;

	static struct {
		const char* id;
		const char* path;
		BOOL(*func)(HTLIB_HANDLE, HTLIB_Header*, short hlen, int seq,
					const char* method, int a);
		int a;
	} ff[] = {
		{ "H11-1(S)", "/http11/abs1", test1 },
		{ "H11-2(S)", "/http11/abs2", test2 },
		{ "H11-3(S)", "/http11/100cont", test3 },
		{ "H11-4(S)", "/http11/reconok1", test4_1 },
		{ "H11-4(S)", "/http11/reconok2", test4_2 },
		{ "H11-5(S)", "/http11/reconng1", test5 },
		{ "H11-6(S)", "/http11/crlf", test6 },
		{ "H10-1(S)", "/http10/keepalive1", test101, 1 },
		{ "H10-1(S)", "/http10/keepalive2", test101, 2 },
		{ "H10-1(S)", "/http10/keepalive", test101, 3 },
		{ "H09-1(S)", "/http09/get", test091, 0},
	};

	int i;
	for (i=0; i<sizeof(ff)/sizeof(ff[0]); i++) {
		if (strcmp(uri, ff[i].path)==0) {
			id = ff[i].id;
			return ff[i].func(h, hh, hlen, seq, method,
							  ff[i].a);
		}
	}

	FAIL("GET-X", "not implemented for %s", uri);
	return FALSE;
}

