#include "server.h"
#include "Session.h"
#include <time.h>
#include "sget.h"
#include "spost.h"
#include "shead.h"
#include "shttp.h"
#include "smisc.h"

static HTLIB_NEEDS_ENUM
needsToParse(HTLIB_HANDLE h,
			 const char* header_name,
			 const char* header_value_all)
{
	if (strcmp(header_name, "User-Agent")==0) {
		printf("need not to parse User-Agent: %s\n", header_value_all);
		return HTLIB_N_ONLY_VALUE;
	}
	if (strcmp(header_name, "Ignore")==0) {
		printf("ignore Ignore: %s\n", header_value_all);
		return HTLIB_N_NONE;
	}
	if (strcmp(header_name, "X-Data0")==0) {
		return HTLIB_N_PARSE_PARAM;
	}
	if (strcmp(header_name, "X-Data1")==0) {
		return HTLIB_N_PARSE_PARAM;
	}
	if (strcmp(header_name, "X-Data2")==0) {
		return HTLIB_N_ONLY_VALUE;
	}
	return HTLIB_N_PARSE_PARAM;
}

void*
doSession(void* arg)
{
	HTLIB ht;
	HTLIB_HANDLE h = &ht;
	HTLIB_ERROR err;
	int seq = 0;
	char send_buffer[1000];
	char rec_buffer[1000];
	if (HTLIB_Init(&ht,
				   send_buffer, sizeof(send_buffer),
				   rec_buffer, sizeof(rec_buffer), &err)==FALSE) {
		FAIL("SYSTEM", "");
		return NULL;
	}
	ht.agent_or_server_name = "tests/1.0";
	
	HTLIB_Attach(&ht, (int)arg);
	
	while(TRUE) {
		const char* uri;
		const char* method;
		HTLIB_Header header_buffer[30];
		HTLIB_USHORT blen = 30;
		
		if ((uri=HTLIB_ReceiveRequest(&ht,
									  10000,
									  &method,
									  header_buffer, &blen,
									  needsToParse,
									  &err))==NULL) {
			if (err == HTLIB_E_TIMEOUT) {
				printf("restart\n");
				continue;
			}
			if (err != HTLIB_E_DISCONNECTED) {
				FAIL("SYSTEM", "ReceiveRequest");
			}
			break;
		}

		seq++;
		
		if (strcmp(uri, "/exit")==0) {
			HTLIB_SendResponse(h, -1, 200, NULL, NULL, 0, "ok", 2, &err);
			HTLIB_CancelAll(TRUE);
			sexit();
			break;
		}
		if (strcmp(uri, "/")==0 || strncmp(uri, "/get", 4)==0) {
			if (testGet(h, uri, method, header_buffer, blen, seq)==FALSE) {
				break;
			}
		}
		if (strncmp(uri, "/head", 5)==0) {
			if (testHead(h, uri, method, header_buffer, blen, seq)==FALSE) {
				break;
			}
		}
		if (strncmp(uri, "/post", 5)==0) {
			if (testPost(h, uri, method, header_buffer, blen, seq)==FALSE) {
				break;
			}
		}
		if (strncmp(uri, "/http", 5)==0) {
			if (testHttp(h, uri, method, header_buffer, blen, seq)==FALSE) {
				break;
			}
		}
		if (strncmp(uri, "/misc", 5)==0) {
			if (testMisc(h, uri, method, header_buffer, blen, seq)==FALSE) {
				break;
			}
		}

	}
	HTLIB_Uninit(&ht);
	printf("session ended\n");
	return NULL;
}
