%union {
    char *str;
    char **attr;
    int attrindex;
    struct hdml_list_list *hdml;
}

%token <str> STAGO ETAGO TAGC
%token <str> COMMENT
%token <str> COMO COMC
%token <str> MARKO PROCO
%token <str> TEXT
%token <str> ' ' '\n' '='

/* elem name */
%token <str> A BASE BLOCKQUOTE BODY BR CENTER DIR DL DT DD DIV FORM HEAD
%token <str> H1 H2 H3 H4 H5 H6 HR HTML IMG
%token <str> INPUT LI MENU OL OPTION P PLAINTEXT PRE SELECT TEXTAREA TITLE UL
%token <str> UNKNOWNELEM

/* attr name */
%token <str>  NAME HREF ACCESSKEY CLEAR ALIGN ACTION METHOD
%token <str>  SIZE WIDTH NOSHADE SRC HEIGHT HSPACE VSPACE ALT BORDER
%token <str>  TYPE MAXLENGTH VALUE CHECKED
%token <str>  START SELECTED MULTIPLE ROWS COLS ISTYLE
%token <str>  UNKNOWNATTR

%token <str>  ATTRVALUESTR


/*  */
%type <attr> intag

%type <str> contents html /* NULL */
%type <str> content       /* NULL */
%type <hdml> selem eelem
%type <hdml> selemA eelemA
%type <hdml> selemIMG
%type <hdml> selemFORM eelemFORM selemSELECT eelemSELECT
%type <hdml> selemTEXTAREA eelemTEXTAREA
%type <hdml> selemPRE eelemPRE
%type <hdml> selemCENTER eelemCENTER
%type <hdml> selemTITLE eelemTITLE
%type <hdml> selemBR selemHR selemINPUT selemOPTION eelemOPTION
%type <hdml> selemDT selemDD
%type <hdml> selemBASE
%type <hdml> selemOL eelemOL selemUL eelemUL selemLI eelemLI
%type <hdml> selemDIR eelemDIR selemMENU eelemMENU
%type <hdml> selemP eelemP
%type <hdml> selemDIV eelemDIV
%type <hdml> selemBLOCKQUOTE eelemBLOCKQUOTE
%type <hdml> selemH1 eelemH1 selemH2 eelemH2 selemH3 eelemH3
%type <hdml> selemH4 eelemH4 selemH5 eelemH5 selemH6 eelemH6

%type <attrindex> attrname

%type <str> elemname
%type <str> spc

%type <str> eq
%type <str> attrvalue attrvaluestr_q

%type <str> incomm comment
%type <str> inmark mark
%type <str> inproc proc

%{

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <assert.h>
#include "html2hdml.h"
#include "strinput.h"

static char *gl_novalue = "";

int yyerror(char *s);

int init_hdml(void);

char **attr_alloc(void);

%}

%%

html: contents  {
    add_header_and_footer();
    print_all(enum_begin);
    free_HDMLblock_list(enum_begin);
}

contents: content
        | contents content


content: selem   { $$ = NULL; }
       | eelem   { $$ = NULL; }
       | TEXT    { $$ = NULL; convert_text($1); }
       | ' '     { $$ = NULL; convert_spc($1); }
       | '\n'    { $$ = NULL; convert_ret(); }
       | comment { $$ = NULL; convert_comment($1); }
       | mark    { $$ = NULL; }
       | proc    { $$ = NULL; }


elemname : BODY | DL
         | HEAD | HTML
         | PLAINTEXT
         | UNKNOWNELEM

selemA: STAGO A intag TAGC
{
    $$ = NULL;
    convert_A($1, $2, $3, $4);
}

eelemA: ETAGO A intag TAGC
{
    $$ = NULL;
    convert_A_($1, $2, $3, $4);
}

selemIMG: STAGO IMG intag TAGC
{
    $$ = NULL;
    convert_IMG($1, $2, $3, $4);
}

selemFORM: STAGO FORM intag TAGC
{
    convert_FORM($1, $2, $3, $4);
    $$ = NULL;
}

eelemFORM: ETAGO FORM intag TAGC
{
    convert_FORM_($1, $2, $3, $4);
    $$ = NULL;
}

selemSELECT: STAGO SELECT intag TAGC
{
    convert_SELECT($1, $2, $3, $4);

    set_current_output(enum_select);
    $$ = NULL;
}

eelemSELECT: ETAGO SELECT intag TAGC
{
    convert_SELECT_($1, $2, $3, $4);

    set_current_output(enum_body);
    $$ = NULL;
}

selemOPTION: STAGO OPTION intag TAGC
{
    $$ = NULL;
    reset_varlist(enum_select);
    convert_OPTION($1, $2, $3, $4);
}

eelemOPTION: ETAGO OPTION intag TAGC
{
    $$ = NULL;
}


selemTEXTAREA: STAGO TEXTAREA intag TAGC
{
    convert_TEXTAREA($1, $2, $3, $4);
    set_current_output(enum_textarea);
    $$ = NULL;
}

eelemTEXTAREA: ETAGO TEXTAREA intag TAGC
{
    convert_TEXTAREA_($1, $2, $3, $4);
    set_current_output(enum_body);
    $$ = NULL;
}

selemPRE: STAGO PRE intag TAGC
{
    convert_PRE($1, $2, $3, $4);
    $$ = NULL;
}

eelemPRE: ETAGO PRE intag TAGC
{
    convert_PRE_($1, $2, $3, $4);
    $$ = NULL;
}

selemCENTER: STAGO CENTER intag TAGC
{
    convert_CENTER($1, $2, $3, $4);
    $$ = NULL;
}

eelemCENTER: ETAGO CENTER intag TAGC
{
    convert_CENTER_($1, $2, $3, $4);
    $$ = NULL;
}

selemTITLE: STAGO TITLE intag TAGC
{
    $$ = NULL;
    set_current_output(enum_title);
}

eelemTITLE: ETAGO TITLE intag TAGC
{
    $$ = NULL;
    set_current_output(enum_body);
}

selemBR: STAGO BR intag TAGC
{
    convert_BR($1, $2, $3, $4);
    $$ = NULL;
}
selemDT: STAGO DT intag TAGC
{
    add_piece(enum_body, "<br>\n");
    $$ = NULL;
}
selemDD: STAGO DD intag TAGC
{
    add_piece(enum_body, "<tab>");
    $$ = NULL;
}

selemP: STAGO P intag TAGC
{
    convert_P($1, $2, $3, $4);
    $$ = NULL;
}
eelemP: ETAGO P intag TAGC
{
    convert_P_($1, $2, $3, $4);
    $$ = NULL;
}
selemDIV: STAGO DIV intag TAGC
{
    convert_P($1, $2, $3, $4);
    $$ = NULL;
}
eelemDIV: ETAGO DIV intag TAGC
{
    convert_CENTER_($1, $2, $3, $4);
    $$ = NULL;
}
selemBLOCKQUOTE: STAGO BLOCKQUOTE intag TAGC
{
    convert_P($1, $2, $3, $4);
    $$ = NULL;
}
eelemBLOCKQUOTE: ETAGO BLOCKQUOTE intag TAGC
{
    convert_P_($1, $2, $3, $4);
    $$ = NULL;
}

selemH1: STAGO H1 intag TAGC
{
    convert_P($1, $2, $3, $4);
    $$ = NULL;
}
eelemH1: ETAGO H1 intag TAGC
{
    convert_P_($1, $2, $3, $4);
    $$ = NULL;
}
selemH2: STAGO H2 intag TAGC
{
    convert_P($1, $2, $3, $4);
    $$ = NULL;
}
eelemH2: ETAGO H2 intag TAGC
{
    convert_P_($1, $2, $3, $4);
    $$ = NULL;
}
selemH3: STAGO H3 intag TAGC
{
    convert_P($1, $2, $3, $4);
    $$ = NULL;
}
eelemH3: ETAGO H3 intag TAGC
{
    convert_P_($1, $2, $3, $4);
    $$ = NULL;
}
selemH4: STAGO H4 intag TAGC
{
    convert_P($1, $2, $3, $4);
    $$ = NULL;
}
eelemH4: ETAGO H4 intag TAGC
{
    convert_P_($1, $2, $3, $4);
    $$ = NULL;
}
selemH5: STAGO H5 intag TAGC
{
    convert_P($1, $2, $3, $4);
    $$ = NULL;
}
eelemH5: ETAGO H5 intag TAGC
{
    convert_P_($1, $2, $3, $4);
    $$ = NULL;
}
selemH6: STAGO H6 intag TAGC
{
    convert_P($1, $2, $3, $4);
    $$ = NULL;
}
eelemH6: ETAGO H6 intag TAGC
{
    convert_P_($1, $2, $3, $4);
    $$ = NULL;
}

selemHR: STAGO HR intag TAGC
{
    convert_HR($1, $2, $3, $4);
    $$ = NULL;
}

selemINPUT: STAGO INPUT intag TAGC
{
    $$ = NULL;
    convert_INPUT($1, $2, $3, $4);
}

selemBASE: STAGO BASE intag TAGC
{
    $$ = NULL;
    convert_BASE($1, $2, $3, $4);
}

selemOL: STAGO OL intag TAGC
{
    $$ = NULL;
    convert_OL($1, $2, $3, $4);
}
eelemOL: ETAGO OL intag TAGC
{
    $$ = NULL;
    convert_OL_($1, $2, $3, $4);
}

selemUL: STAGO UL intag TAGC
{
    $$ = NULL;
    convert_UL($1, $2, $3, $4);
}
eelemUL: ETAGO UL intag TAGC
{
    $$ = NULL;
    convert_UL_($1, $2, $3, $4);
}

selemDIR: STAGO DIR intag TAGC
{
    $$ = NULL;
    convert_UL($1, $2, $3, $4);
}
eelemDIR: ETAGO DIR intag TAGC
{
    $$ = NULL;
    convert_UL_($1, $2, $3, $4);
}

selemMENU: STAGO MENU intag TAGC
{
    $$ = NULL;
    convert_UL($1, $2, $3, $4);
}
eelemMENU: ETAGO MENU intag TAGC
{
    $$ = NULL;
    convert_UL_($1, $2, $3, $4);
}

selemLI: STAGO LI intag TAGC
{
    $$ = NULL;
    convert_LI($1, $2, $3, $4);
}

eelemLI: ETAGO LI intag TAGC
{
    $$ = NULL;
}


selem: STAGO elemname intag TAGC { $$ = NULL; }
     | STAGO error TAGC { $$ = NULL; yyerrok; }
     | selemA
     | selemIMG
     | selemFORM
     | selemSELECT
     | selemTEXTAREA
     | selemPRE
     | selemCENTER
     | selemTITLE
     | selemBR
     | selemDT
     | selemDD
     | selemHR
     | selemINPUT
     | selemOPTION
     | selemBASE
     | selemOL
     | selemUL
     | selemDIR
     | selemMENU
     | selemLI
     | selemP
     | selemDIV
     | selemBLOCKQUOTE
     | selemH1
     | selemH2
     | selemH3
     | selemH4
     | selemH5
     | selemH6

eelem: ETAGO elemname intag TAGC { $$ = NULL; }
     | ETAGO error TAGC { $$ = NULL; yyerrok; }
     | eelemA
     | eelemFORM
     | eelemSELECT
     | eelemTEXTAREA
     | eelemPRE
     | eelemCENTER
     | eelemTITLE
     | eelemOPTION
     | eelemOL
     | eelemUL
     | eelemDIR
     | eelemMENU
     | eelemLI
     | eelemP
     | eelemDIV
     | eelemBLOCKQUOTE
     | eelemH1
     | eelemH2
     | eelemH3
     | eelemH4
     | eelemH5
     | eelemH6

attrname: NAME        { $$ = (int)enum_NAME; }
        | HREF        { $$ = (int)enum_HREF; }
        | ACCESSKEY   { $$ = (int)enum_ACCESSKEY; }
        | CLEAR       { $$ = (int)enum_CLEAR; }
        | ALIGN       { $$ = (int)enum_ALIGN; }
        | ACTION      { $$ = (int)enum_ACTION; }
        | METHOD      { $$ = (int)enum_METHOD; }
        | SIZE        { $$ = (int)enum_SIZE; }
        | WIDTH       { $$ = (int)enum_WIDTH; }
        | NOSHADE     { $$ = (int)enum_NOSHADE; }
        | SRC         { $$ = (int)enum_SRC; }
        | HEIGHT      { $$ = (int)enum_HEIGHT; }
        | HSPACE      { $$ = (int)enum_HSPACE; }
        | VSPACE      { $$ = (int)enum_VSPACE; }
        | ALT         { $$ = (int)enum_ALT; }
        | BORDER      { $$ = (int)enum_BORDER; }
        | TYPE        { $$ = (int)enum_TYPE; }
        | MAXLENGTH   { $$ = (int)enum_MAXLENGTH; }
        | VALUE       { $$ = (int)enum_VALUE; }
        | CHECKED     { $$ = (int)enum_CHECKED; }
        | START       { $$ = (int)enum_START; }
        | SELECTED    { $$ = (int)enum_SELECTED; }
        | MULTIPLE    { $$ = (int)enum_MULTIPLE; }
        | ROWS        { $$ = (int)enum_ROWS; }
        | COLS        { $$ = (int)enum_COLS; }
        | ISTYLE      { $$ = (int)enum_ISTYLE; }
        | UNKNOWNATTR { $$ = (int)enum_UNKNOWNATTR; }

intag: spc { $$ = attr_alloc(); }
     | intag attrname spc                    { $1[$2] = gl_novalue; }
     | intag attrname error spc              { yyerrok; $1[$2] = gl_novalue; }
     | intag attrname eq attrvalue spc       { $1[$2] = $4; }
     | intag attrname eq attrvalue error spc { yyerrok; $1[$2] = $4; }
     | intag error spc                       { yyerrok; }

eq:     '='     { $$ = $1; }
  |     '=' spc { $$ = $1; }
  | spc '='     { $$ = $2; }
  | spc '=' spc { $$ = $2; }

attrvaluestr_q: ATTRVALUESTR { $$ = $1; }
              | ' '          { $$ = $1; }
              | '\n'         { $$ = $1; }
              | ATTRVALUESTR attrvaluestr_q { $$ = $1; }
              | ' '          attrvaluestr_q { $$ = $1; }
              | '\n'         attrvaluestr_q { $$ = $1; }

attrvalue: ATTRVALUESTR           { $$ = $1; }
         | '\'' attrvaluestr_q '\'' { $$ = $2; }
         | '"' attrvaluestr_q '"'   { $$ = $2; }
         | '\'' '\''              { $$ = ""; }
         | '"'  '"'               { $$ = ""; }

/*
intag: spc { $$ = attr_alloc(); }
     | intag attrname spc                  { $1[$2] = gl_novalue; }
     | intag attrname '=' ATTRVALUESTR spc { $1[$2] = $4; }
     | intag error spc { yyerrok; }
*/

spc: ' '
   | '\n'
   | spc ' '
   | spc '\n'

comment: COMMENT
       | incomm COMC TAGC
       | incomm COMC spc TAGC

mark: inmark TAGC

proc: inproc TAGC

incomm: COMO
      | incomm TEXT
      | incomm ' '
      | incomm '\n'


inmark: MARKO
      | MARKO spc
      | inmark TEXT spc  { $$ = $2; }
      | inmark error spc { yyerrok; }

inproc: PROCO
      | PROCO spc
      | inproc TEXT spc  { $$ = $2; }
      | inproc error spc { yyerrok; }

%%

int parse_html(void)
{
    init_hdml();
    yyparse();
    return 0;
}

int yyerror(char *s)
{
    fprintf(stderr, "yyerror(): line %d: %s\n", gl_lineno, s);
    return 0;
}

int init_hdml(void)
{
    init_cardnum();
    init_hdmlstruct();
    return 0;
}

char **attr_alloc(void)
{
    return my_calloc((int)sizeof_attrname, sizeof(char *));
}


