#ifndef _HTML2HDML_H
#define _HTML2HDML_H

#ifdef ZODIAX
#define CONVERT_A_HREF_HTML2HDML 0
#define CONVERT_IMG 1
#define CONVERT_IMG_GIF2BMP 1
#endif /* ZODIAX */

/*
  CONVERT_A_HREF_HTML2HDML:
    If defined, convert '.html' into '.hdml' in <A HREF=>
*/
#ifndef CONVERT_A_HREF_HTML2HDML
#define CONVERT_A_HREF_HTML2HDML 1
#endif

#ifdef MOD_HTML2HDML

#include "httpd.h"
//#include "alloc.h"

extern struct pool *gl_pool;

/*
#define my_strdup(str)         ap_pstrdup(gl_pool, str)
#define my_malloc(size)        ap_pcalloc(gl_pool, size)
#define my_calloc(nelem, size) ap_pcalloc(gl_pool, nelem*size)
#define my_free(str)
*/
#define my_strdup(str) strdup(str)
#define my_malloc(size) malloc(size)
#define my_calloc(nelem, size) calloc(nelem, size)
#define my_free(str) free(str)

#else

#define my_strdup(str) strdup(str)
#define my_malloc(size) malloc(size)
#define my_calloc(nelem, size) calloc(nelem, size)
#define my_free(str) free(str)

#endif

/*
  CONVERT_IMG:
    If defined, convert <IMG> elements.

  CONVERT_IMG_GIF2BMP:
    If defined, convert '.gif' into '.bmp' in <IMG SRC=>
*/
#ifndef CONVERT_IMG
#define CONVERT_IMG 1
#endif
#ifndef CONVERT_IMG_ALT
#define CONVERT_IMG_ALT 1
#endif
#ifndef CONVERT_IMG_GIF2BMP
#define CONVERT_IMG_GIF2BMP 1
#endif

# ifdef _MSC_VER
#define RET_STR "\n"
# else
#define RET_STR "\r\n"
# endif /* _MSC_VER */

#define BUFFER_SIZE 4096

#ifndef strcmpi
# ifdef _MSC_VER
# define strcmpi _strcmpi /* Visual C++*/
# else
# define strcmpi strcasecmp /* Solaris */
# endif /* _MSC_VER */
#endif

#ifndef strncmpi
# ifdef _MSC_VER
# define strncmpi _strncmpi /* Visual C++*/
# else
# define strncmpi strncasecmp /* Solaris */
# endif /* _MSC_VER */
#endif


struct _hdml_piece {
  char *str;
  int including_sp_char;
  struct _hdml_piece *next;
};

struct _hdml_block {
    int remove_last_amp;
    int dont_free;
    struct _hdml_block *next;
    struct _hdml_piece *top;
    struct _hdml_piece *bottom;
};

struct _hdml {
    struct _hdml_block *all;    /* top of header */
    struct _hdml_block *header; /* last of header. header->next==top of body */
    struct _hdml_block *body;   /* last of body. body->next==top of footer */
    struct _hdml_block *footer; /* last of footer. head->next==NULL */
};

typedef struct _hdml_piece HDMLpiece;
typedef struct _hdml_block HDMLblock;
typedef struct _hdml_block HDML;

enum attrname {
    enum_NAME, enum_HREF, enum_ACCESSKEY, enum_CLEAR, enum_ALIGN,
    enum_ACTION, enum_METHOD, enum_SIZE, enum_WIDTH, enum_NOSHADE,
    enum_SRC, enum_HEIGHT, enum_HSPACE, enum_VSPACE,
    enum_ALT, enum_BORDER, 
    enum_TYPE, enum_MAXLENGTH, enum_VALUE, enum_CHECKED,
    enum_START, enum_SELECTED, enum_MULTIPLE,
    enum_ROWS, enum_COLS, enum_ISTYLE, 
    enum_UNKNOWNATTR,
    sizeof_attrname
};

enum inputtype {
    enum_TEXT, enum_PASSWORD, enum_CHECKBOX, enum_RADIO,
    enum_HIDDEN, enum_SUBMIT, enum_RESET, enum_UNKNOWNTYPE
};

enum hdmloutput {
    enum_current,
    enum_begin, enum_header, enum_body, enum_footer,
    enum_init, enum_reset, enum_submit,
    enum_title, enum_textarea,
    enum_select, enum_select_selected,
};

/*** html2hdml.y ***/
extern int parse_html(void);

/*** convert.c ***/
extern int init_cardnum(void);
extern int add_header_and_footer(void);

extern int convert_BR(char *stago, char *elemname, char **attr, char *tagc);
extern int convert_HR(char *stago, char *elemname, char **attr, char *tagc);
extern int convert_P(char *stago, char *elemname, char **attr, char *tagc);
extern int convert_P_(char *stago, char *elemname, char **attr, char *tagc);

extern int convert_A(char *stago, char *elemname, char **attr, char *tagc);
extern int convert_A_(char *stago, char *elemname, char **attr, char *tagc);
extern int convert_IMG(char *stago, char *elemname, char **attr, char *tagc);
extern int convert_IMG_(char *stago, char *elemname, char **attr, char *tagc);

extern int convert_FORM(char *stago, char *elemname, char **attr, char *tagc);
extern int convert_FORM_(char *stago, char *elemname, char **attr, char *tagc);

extern int convert_INPUT(char *stago, char *elemname, char **attr, char *tagc);
extern int convert_SELECT(char *stago, char *elemname, char **attr, char *tagc);
extern int convert_SELECT_(char *stago, char *elemname, char **attr, char *tagc);
extern int convert_OPTION(char *stago, char *elemname, char **attr, char *tagc);
extern int convert_TEXTAREA(char *stago, char *elemname, char **attr, char *tagc);
extern int convert_TEXTAREA_(char *stago, char *elemname, char **attr, char *tagc);
extern int convert_PRE(char *stago, char *elemname, char **attr, char *tagc);
extern int convert_PRE_(char *stago, char *elemname, char **attr, char *tagc);
extern int convert_CENTER(char *stago, char *elemname, char **attr, char *tagc);
extern int convert_CENTER_(char *stago, char *elemname, char **attr, char *tagc);

extern int convert_BASE(char *stago, char *elemname, char **attr, char *tagc);


extern int convert_text(char *text);
extern int convert_ret(void);
extern int convert_spc(char *spc);
extern int convert_comment(char *text);

/*** list.c ***/
extern int convert_OL(char *stago, char *elemname, char **attr, char *tagc);
extern int convert_OL_(char *stago, char *elemname, char **attr, char *tagc);
extern int convert_UL(char *stago, char *elemname, char **attr, char *tagc);
extern int convert_UL_(char *stago, char *elemname, char **attr, char *tagc);
extern int convert_LI(char *stago, char *elemname, char **attr, char *tagc);

/*** hdmlstruct.c ***/
extern HDMLblock *add_piece(enum hdmloutput hdml, char *str);
extern HDMLblock *add_piece_with_sp_char(enum hdmloutput hdml, char *str);
//extern HDMLblock *add_piece(HDMLblock *hdml, char *str);
extern HDMLblock *append_block(HDMLblock *hdml, HDMLblock *block);
extern int append_varlist(enum hdmloutput output, enum hdmloutput varnum, 
			  int remove_last_amp);
extern int catdup_varlist(enum hdmloutput output, enum hdmloutput varnum);
extern int reset_varlist(enum hdmloutput varnum);
extern int is_varlist_empty(enum hdmloutput varnum);
extern int init_hdmlstruct(void);
extern int print_all(enum hdmloutput output);

extern HDMLpiece *alloc_HDMLpiece(char *str, int sp_char);
extern HDMLblock *alloc_HDMLblock(HDMLblock *src);
extern void free_HDMLblock_list(enum hdmloutput output);

extern int is_current_output(enum hdmloutput output);
extern int set_current_output(enum hdmloutput output);
extern int set_select_selected(void);

/*** radionum.c ***/
extern int find_radionum(char *name);
extern int add_radionum(char *name, int cardnum);
extern void clear_radionum(void);


extern int gl_lineno;
#endif /* _HTML2HDML_H */
