/*
 * html2hdml
 *
 * Coprygight (C) 2000-2003 Dino Co.,Ltd.
 * http://www.dino.co.jp/
 */
#ifdef HAVE_CONFIG_H
# include <config.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "strinput.h"
#include "html2hdml.h"
#include <time.h>

const char *myinput;
char *myinputptr;
char *myinputlim;

struct clientinfo gl_clientinfo;
struct convertopt gl_convertopt;

int set_inputstr(const char *input, int inputlen)
{
    myinput = input;
    myinputptr = (char *)input;
    myinputlim = myinputptr+inputlen;

    return 0;
}

int func(const char *buffer, int buf_len,
	 struct clientinfo *clientinfo,
	 struct convertopt *convertopt)
{
    gl_clientinfo = *clientinfo;
    gl_convertopt = *convertopt;

    set_inputstr(buffer, buf_len);
    parse_html();

    return 0;
}

int set_default_opt(void)
{
    gl_clientinfo.row    = 10;
    gl_clientinfo.column = 10;

    gl_convertopt.a_href_html2hdml = 1;
    gl_convertopt.img              = 1;
    gl_convertopt.img_src_gif2bmp  = 1;
    gl_convertopt.img_alt          = 0;
    
    return 0;
}

#ifndef ZODIAX
int main(int argc, char **argv)
{
    char buf_stack[BUFFER_SIZE], *buf, *ptr;
    int n;
    int var_for_debug; /* for deadline check */
    int need_to_close = 1;
    int heap_used = 0;
    FILE *fp;
    int bufsize;

    set_default_opt();

    var_for_debug = 1; /* always OK */

    if (argc >= 2) {
        fp = fopen(argv[1], "rb");
	if (fp == NULL) {
	    return 0;
	}
    } else {
	fp = stdin;
	need_to_close = 0;
    }

    n = fread(buf_stack, sizeof(char), BUFFER_SIZE-1, fp);
    buf_stack[n] = '\0';

    if (feof(fp)) {
	buf = buf_stack;
	bufsize = n+1;
    } else {
	heap_used = 1;

	bufsize = n+1;
	buf = malloc(bufsize*sizeof(char));
	ptr = buf;

	/* realloc & copy */
	memcpy(ptr, buf_stack, n);

	do {
	    n = fread(buf_stack, sizeof(char), BUFFER_SIZE-1, fp);
	    buf_stack[n] = '\0';
	    if (n) {
		buf = realloc(buf, (bufsize+n)*sizeof(char));
		ptr = buf+bufsize-1;
		bufsize += n;

		memcpy(ptr, buf_stack, n);
	    }
	} while (!feof(fp));
	buf[bufsize-1] = '\0';
    }
    if (need_to_close) fclose(fp);

    if (bufsize > 1500) {
	fprintf(stderr, "warning: input HTML is over 1500bytes.\n");
    }

    set_inputstr(buf, bufsize-1);

    if (var_for_debug) {
      parse_html();
    }

    if (heap_used) free(buf);
    return 0;
}
#endif /* ZODIAX */
