/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package an;

import org.opengion.fukurou.business.BizLogic_ENTRY;

/**
 * パスワード変更 (OP1012) の業務ロジックです。
 *
 * @og.rev 2010/06/18 新規作成
 * 
 * @version 5.0
 * @author Hiroki Nakamura
 * @since JDK1.6,
 */

public class OP1012A extends BizLogic_ENTRY {

	/**
	 * チェックロジックを定義します。
	 * 
	 * @return 処理が正常終了したか
	 */
	@Override
	protected boolean check() {
		// ANE0019:パスワードが一致していません。
		if( !var( "PASSWD").equals( var( "PASSWD2" ) ) ) {
			error( 2, "ANE0019" );
		}

		// ANE0021:パスワードは、6文字以上で登録して下さい。
		if( var( "PASSWD" ).length() < 6 ) {
			error( 2, "ANE0021" );
		}

		return true;
	}

	/**
	 * メイン処理を定義します。
	 * 
	 * @return 処理が正常終了したか
	 */
	@Override
	protected boolean logic() {
		String sql = "update AN04 set"
			+ " PASSWD = '{@PASSWD}'"
			+ ",DYUPD = '{@CON.YMDH}'"
			+ ",PGUPD = '{@CON.PGID}'"
			+ ",PGPUPD = '{@CON.PGPID}'"
			+ ",USRUPD = '{@CON.USERID}'"
			+ " where USERID = '{@CON.USERID}'";
		sql( sql );

		return true;
	}
}

