/*
 * Copyright (c) 2009 The openGion Project.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific language
 * governing permissions and limitations under the License.
 */
package an;

import org.opengion.fukurou.business.BizLogic_CURSOR;

/**
 * アンケートの得点比率から実際の得点を計算するため の 業務ロジックです。
 *
 * @og.rev 2010/06/18 新規作成
 * 
 * @version 5.0
 * @author Hiroki Nakamura
 * @since JDK1.6,
 */
public class PointCalc extends BizLogic_CURSOR {

	private int	zpoint = 100;

	/**
	 * 配列型テーブルモデルを生成するためのSQL文を定義します。
	 * このメソッドからSQL文から返された場合、この結果セットから配列型テーブルモデルを生成し、
	 * メインカーソルとして使用します。
	 * 
	 * @return 配列型テーブルモデルを生成するためのSQL文
	 */
	@Override
	protected String cursor() {
		String cur = "select UNIQ,SUPTRITSU,SEQNO from AN02"
					+ " where USERID = '{@CON.USERID}'"
					+ " and CDANK = '{@CDANK}'"
					+ " and FGJ = '1' order by SEQNO";
		return cur;
	}

	/**
	 * メインカーソルの一番初めで呼ばれるチェックロジックを定義します。
	 * 
	 * ここでは、画像ファイルを仮置きの場所(filetemp/$USREID/imgtemp)に展開しています。
	 * 
	 * @rev 
	 * 
	 * @return 処理が正常終了したか
	 */
	@Override
	protected boolean fstchk() {
		return must( "CDANK" );
	}

	/**
	 * メインカーソルの一番初めで呼ばれるロジックを定義します。
	 * 
	 * @return 処理が正常終了したか
	 */
	@Override
	protected boolean first() {
		String sql = "select sum(SUPTRITSU) SUM_SUPTRITSU, max(SEQNO) MAX_SEQNO from AN02"
					+ " where USERID = '{@CON.USERID}'"
					+ " and CDANK = '{@CDANK}'"
					+ " and FGJ = '1'";
		sql( sql );
		if( vari( "SUM_SUPTRITSU" ) == 0 ) { return false; }
		return true;
	}

	/**
	 * メインカーソルの各行(変更区分の各処理の後)で呼ばれるロジックを定義します。
	 * 
	 * @param row 行番号
	 * @return 処理が正常終了したか
	 */
	@Override
	protected boolean allrow( final int row ) {
		int cpoint;
		if( line( "SEQNO" ).equals( var( "MAX_SEQNO" ) ) ) {
			cpoint = zpoint;
		}
		else {
			cpoint = linei( "SUPTRITSU" ) * 100 / vari( "SUM_SUPTRITSU" );
			zpoint -= cpoint;
		}
		set( "SUPOINT", cpoint );

		String sql = "update AN02 set SUPOINT = {@SUPOINT} where UNIQ = [UNIQ]";
		sql( sql );
		return true;
	}
}
