/*
 * Decompiled with CFR 0.152.
 */
package iax.protocol.frame;

import iax.protocol.frame.FrameException;
import iax.protocol.frame.FullFrame;

public class VoiceFrame
extends FullFrame {
    private byte[] data;

    protected VoiceFrame() {
    }

    public VoiceFrame(int srcCallNo, boolean retry, int destCallNo, long timeStamp, int oSeqno, int iSeqno, boolean subclassValueFormat, int subclass, byte[] data) {
        super(4, srcCallNo, retry, destCallNo, timeStamp, oSeqno, iSeqno, 2, subclassValueFormat, subclass);
        this.data = data;
    }

    public VoiceFrame(byte[] buffer) throws FrameException {
        super(4, buffer);
        try {
            this.data = new byte[buffer.length - 12];
            System.arraycopy(buffer, 12, this.data, 0, this.data.length);
        }
        catch (Exception e) {
            throw new FrameException(e);
        }
    }

    public byte[] getData() {
        return this.data;
    }

    public byte[] serialize() throws FrameException {
        try {
            byte[] superInBytes = super.serialize();
            byte[] thisInBytes = new byte[superInBytes.length + this.data.length];
            System.arraycopy(superInBytes, 0, thisInBytes, 0, superInBytes.length);
            System.arraycopy(this.data, 0, thisInBytes, superInBytes.length, this.data.length);
            return thisInBytes;
        }
        catch (Exception e) {
            throw new FrameException(e);
        }
    }
}

