/*
 * Decompiled with CFR 0.152.
 */
package iax.audio.impl;

import iax.audio.Player;
import iax.audio.PlayerException;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;
import org.tritonus.lowlevel.gsm.GSMDecoder;

public class GSMPlayer
extends Player {
    AudioFormat pcmFormat = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 8000.0f, 16, 1, 2, 8000.0f, false);
    SourceDataLine sourceDataLine;
    GSMDecoder decoder;

    public GSMPlayer() throws PlayerException {
        super(1);
        this.openSourceDataLine();
        this.decoder = new GSMDecoder();
    }

    private void openSourceDataLine() {
        DataLine.Info info = new DataLine.Info(SourceDataLine.class, this.pcmFormat);
        try {
            this.sourceDataLine = (SourceDataLine)AudioSystem.getLine(info);
            this.sourceDataLine.open(this.pcmFormat);
        }
        catch (LineUnavailableException e) {
            e.printStackTrace();
        }
    }

    public void play() {
        this.sourceDataLine.start();
    }

    public void stop() {
        this.sourceDataLine.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(long timestamp, byte[] audioData, boolean absolute) {
        try {
            SourceDataLine sourceDataLine = this.sourceDataLine;
            synchronized (sourceDataLine) {
                int len = 320;
                byte[] tempBuffer = new byte[len];
                this.decoder.decode(audioData, 0, tempBuffer, 0, false);
                this.sourceDataLine.write(tempBuffer, 0, len);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

