/*
 * Decompiled with CFR 0.152.
 */
package iax.protocol.peer.command.recv;

import iax.protocol.frame.ProtocolControlFrame;
import iax.protocol.peer.Peer;
import iax.protocol.peer.command.send.PeerCommandSendFacade;
import iax.protocol.util.FrameUtil;

public class PeerCommandRecvFacade {
    private PeerCommandRecvFacade() {
    }

    public static void ack(Peer peer, ProtocolControlFrame ackFrame) {
        peer.ackedFrame(ackFrame.getTimestamp());
    }

    public static void hangup(Peer peer, ProtocolControlFrame hangupFrame) {
        PeerCommandSendFacade.ack(peer, hangupFrame);
    }

    public static void poke(Peer peer, ProtocolControlFrame poke) {
        PeerCommandSendFacade.pong(peer, poke);
    }

    public static void regack(Peer peer, ProtocolControlFrame regack) {
        int[] repliedSubclasses = FrameUtil.getReplySubclasses(regack.getSubclass());
        int i = 0;
        while (i < repliedSubclasses.length) {
            peer.repliedFrame(repliedSubclasses[i]);
            ++i;
        }
        PeerCommandSendFacade.ack(peer, regack);
    }

    public static void regauthRel(Peer peer, ProtocolControlFrame regauth) {
        int[] repliedSubclasses = FrameUtil.getReplySubclasses(regauth.getSubclass());
        int i = 0;
        while (i < repliedSubclasses.length) {
            peer.repliedFrame(repliedSubclasses[i]);
            ++i;
        }
        PeerCommandSendFacade.regrel(peer, regauth);
    }

    public static void regauthReq(Peer peer, ProtocolControlFrame regauth) {
        int[] repliedSubclasses = FrameUtil.getReplySubclasses(regauth.getSubclass());
        int i = 0;
        while (i < repliedSubclasses.length) {
            peer.repliedFrame(repliedSubclasses[i]);
            ++i;
        }
        PeerCommandSendFacade.regreq(peer, regauth);
    }

    public static void regrej(Peer peer, ProtocolControlFrame regrej) {
        int[] repliedSubclasses = FrameUtil.getReplySubclasses(regrej.getSubclass());
        int i = 0;
        while (i < repliedSubclasses.length) {
            peer.repliedFrame(repliedSubclasses[i]);
            ++i;
        }
        PeerCommandSendFacade.ack(peer, regrej);
    }

    public static void unsupport(Peer peer, ProtocolControlFrame unsupportFrame) {
        PeerCommandSendFacade.ack(peer, unsupportFrame);
    }
}

