#include "keyboard.h"

const char KeyMapper::KeyMap_101US[] = {
 0 ,  0 , '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', '-', '^',  0 ,  0 ,
'Q', 'W', 'E', 'R', 'T', 'Y', 'U', 'I', 'O', 'P', '@', '[',  0 ,  0 , 'A', 'S',
'D', 'F', 'G', 'H', 'J', 'K', 'L', ';', ':',  0 ,  0 , ']', 'Z', 'X', 'C', 'V',
'B', 'N', 'M', ',', '.', '/',  0 , '*',  0 , ' ',  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,
 0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 , '7', '8', '9', '-', '4', '5', '6', '+', '1',
'2', '3', '0', '.',  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,
 0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,
 0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0 ,  0
};

KeyInfo KeyMapper::translate(uint8 code) {
    KeyInfo info = {0, 0};
    switch (code) {
    case EXTEND0_KEY_CODE:
        break;
    case EXTEND1_KEY_CODE:
        break;
    default:
        if ((code & BREAK_KEY_CODE) == BREAK_KEY_CODE) {
            info.ExtendCode |= BREAK_KEY_CODE;
        }
        info.AsciiCode = KeyMap[code & ~BREAK_KEY_CODE];
        break;
    }
    return info;
}

