#ifndef __KEYBOARD_H__
#define __KEYBOARD_H__

#include "kernel.h"
#include "intmgr.h"

class KeyboardInterruptHandler : public InterruptHandler
{
public:
    void operator()(uint32 intNum) {
        uint8 data = IoPortLib::in8(IoPortLib::KBD_DATA);
        IntMgr::setEoi(IntMgr::KEYBOARD_IRQ);
        Kernel::sendMessage(data);
    }
};

struct KeyInfo {
    uint8 AsciiCode;
    uint8 ExtendCode;
} __attribute__ ((packed));

class KeyMapper
{
public:
    static const uint8 EXTEND0_KEY_CODE = 0xE0;
    static const uint8 EXTEND1_KEY_CODE = 0xE1;
    static const uint8 BREAK_KEY_CODE   = 0x80;

    KeyMapper(void) : KeyMap(KeyMap_101US) {}
    KeyInfo translate(uint8 code);

private:
    static const char KeyMap_101US[];
    const char* KeyMap;
};

#endif /*__KEYBOARD_H__ */
